<!DOCTYPE html>
<html prefix="og: http://ogp.me/ns#" lang="en">

<head>

    <title>{content_meta_title}</title>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>

    <meta property="og:title" content="{content_meta_title}"/>
    <meta name="keywords" content="{content_meta_keywords}"/>
    <meta name="description" content="{content_meta_description}"/>
    <meta property="og:type" content="{og_type}"/>
    <meta property="og:url" content="{content_url}"/>
    <meta property="og:image" content="{content_image}"/>
    <meta property="og:description" content="{og_description}"/>
    <meta property="og:site_name" content="{og_site_name}"/>

    <script>
        mw.require('icon_selector.js');
        mw.lib.require('bootstrap4');
        mw.lib.require('bootstrap_select');

        mw.iconLoader()
            .addIconSet('fontAwesome')
            .addIconSet('iconsMindLine')
            .addIconSet('iconsMindSolid')
            .addIconSet('mwIcons')
            .addIconSet('materialIcons');
    </script>

    <script>
        $(document).ready(function () {
            $('.selectpicker').selectpicker();
        });
    </script>

    <!-- Plugins Styles -->
    <link href="<?php print template_url(); ?>assets/plugins/magnific-popup/magnific-popup.css" rel="stylesheet"/>

    <link href="<?php print template_url(); ?>assets/js/libs/swiper/css/swiper.min.css" rel="stylesheet"/>

    <link href="<?php print template_url(); ?>assets/css/typography.css" rel="stylesheet"/>

    <?php print get_template_stylesheet(); ?>

    <link href="<?php print template_url(); ?>assets/css/custom.css" rel="stylesheet"/>


    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <?php include('template_settings_options.php'); ?>

</head>
<body class="<?php print helper_body_classes(); ?> <?php print 'member-nav-inverse header-inverse' . $header_style . ' ' . $sticky_navigation; ?> ">
<module type="template_settings" id="mw-template-beauty"/>

<div class="js-ajax-loading">
    <module type="logo" id="header-logo-loading" logo-name="header-logo" class="w-100"/>
</div>

<div class="main">
    <div class="navigation-holder">
        <nav class="navigation">
            <div class="container">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <module type="logo" class="logo" id="header-logo"/>

                    <div class="menu">
                        <module type="menu" id="header-menu" template="navbar"/>

                        <ul class="list mobile-list">
                            <?php if ($profile_link == 'true'): ?>
                                <li class="mobile-profile">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="true"><i class="fa fa-user-circle-o"></i> <span>Hi <?php print user_name(); ?> <span class="caret"></span></span></a>
                                    <ul class="dropdown-menu">
                                        <?php if (user_id()): ?>
                                            <li><a href="#" data-toggle="modal" data-target="#loginModal"><?php _lang("Profile", "templates/beauty"); ?></a></li>
                                            <li><a href="#" data-toggle="modal" data-target="#ordersModal"><?php _lang("My Orders", "templates/beauty"); ?></a></li>
                                        <?php else: ?>
                                            <li><a href="#" data-toggle="modal" data-target="#loginModal"><?php _lang("Login", "templates/beauty"); ?></a></li>
                                        <?php endif; ?>

                                        <?php if (is_admin()): ?>
                                            <li><a href="<?php print admin_url() ?>"><?php _lang("Admin panel", "templates/beauty"); ?></a></li>
                                        <?php endif; ?>

                                        <?php if (user_id()): ?>
                                            <li><a href="<?php print api_link('logout') ?>"><?php _lang("Logout", "templates/beauty"); ?></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </li>
                            <?php endif; ?>

                            <li class="mobile-search">
                                <form action="<?php print site_url(); ?>search.php" method="get">
                                    <i class="mdi mdi-magnify"></i>
                                    <input type="search" id="keywords" name="keywords"/>
                                    <button type="submit"><?php _lang("Search", "templates/beauty"); ?></button>
                                </form>
                            </li>
                        </ul>
                    </div>

                    <div class="toggle">
                        <a href="javascript:;" class="js-menu-toggle">
                            <span class="mobile-menu-label">
                                <b><?php _lang("Menu", "templates/beauty"); ?></b>
                                <b><?php _lang("Close", "templates/beauty"); ?></b>
                            </span>
                            <span class="mobile-menu-btn">
                                <span></span>
                                <span></span>
                                <span></span>
                            </span>
                        </a>
                    </div>

                    <ul class="member-nav">
                        <li class="btn-search edit nodrop safe-mode" field="beauty_header_phone" rel="global">
                            <div class="search">
                                <p>+359 123 456 789</p>
                            </div>
                        </li>

                        <?php if ($shopping_cart == 'true'): ?>
                            <li class="dropdown btn-cart">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="fa fa-shopping-basket"></i> <span><span id="shopping-cart-quantity"><?php print cart_sum(false); ?></span> <span class="caret"></span></span></a>
                                <div class="dropdown-menu shopping-cart">
                                    <module type="shop/cart" template="small"/>
                                </div>
                            </li>
                        <?php endif; ?>

                        <?php if ($profile_link == 'true'): ?>
                            <li class="dropdown btn-member">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="fa fa-user-circle-o"></i> <span><?php _lang("Hi", "templates/beauty"); ?> <?php print user_name(); ?> <span class="caret"></span></span></a>
                                <ul class="dropdown-menu">
                                    <?php if (user_id()): ?>
                                        <li><a href="#" data-toggle="modal" data-target="#loginModal"><?php _lang("Profile", "templates/beauty"); ?></a></li>
                                        <li><a href="#" data-toggle="modal" data-target="#ordersModal"><?php _lang("My Orders", "templates/beauty"); ?></a></li>
                                    <?php else: ?>
                                        <li><a href="#" data-toggle="modal" data-target="#loginModal"><?php _lang("Login", "templates/beauty"); ?></a></li>
                                    <?php endif; ?>

                                    <?php if (is_admin()): ?>
                                        <li><a href="<?php print admin_url() ?>"><?php _lang("Admin panel", "templates/beauty"); ?></a></li>
                                    <?php endif; ?>

                                    <?php if (user_id()): ?>
                                        <li><a href="<?php print api_link('logout') ?>"><?php _lang("Logout", "templates/beauty"); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php endif; ?>
                    </ul>

                </div>
            </div>
        </nav>
    </div>
