<?php
/*
 * This file is part of the Microweber framework.
 *
 * (c) Microweber CMS LTD
 *
 * For full license information see
 * https://github.com/microweber/microweber/blob/master/LICENSE
 *
 */

namespace MicroweberPackages\Event;

use Illuminate\Support\ServiceProvider;


class EventManagerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        /**
         * @property \MicroweberPackages\Event\\EventManager    $event_manager
         */
        $this->app->singleton('event_manager', function ($app) {
            return new Event($app);
        });

    }
}
