/* Keep track of the current element that is being hovered. */
var _currentElement;

/* Keep track of the state of the Flash object. */
var _flashState = {
  // Flash object reference
  bridge: null,

  // Flash metadata
  version: "0.0.0",
  pluginType: "unknown",

  // Flash state
  disabled: null,
  outdated: null,
  unavailable: null,
  deactivated: null,
  overdue: null,
  ready: null
};

/* Keep track of data and formats for the pending clipboard transaction. */
var _clipData = {};
var _clipDataFormatMap = null;

/* Keep track of the ZeroClipboard client instance counter. */
var _clientIdCounter = 0;

/*
 * Keep track of the state of the client instances.
 *
 * Entry structure:
 *   _clientMeta[client.id] = {
 *     instance: client,
 *     elements: [],
 *     handlers: {}
 *   };
 */
var _clientMeta = {};

/* Keep track of the ZeroClipboard clipped elements counter. */
var _elementIdCounter = 0;

/*
 * Keep track of the state of the clipped element relationships to clients.
 *
 * Entry structure:
 *   _elementMeta[element.zcClippingId] = [client1.id, client2.id];
 */
var _elementMeta = {};

/* The presumed location of the "ZeroClipboard.swf" file based on the location of the JS. */
var _swfPath = (function() {
  var i, jsDir, tmpJsPath, jsPath,
      swfPath = "ZeroClipboard.swf";
  // Try to leverage the `currentScript` feature
  if (!(document.currentScript && (jsPath = document.currentScript.src))) {
    // If it it not available, then seek the script out instead...
    var scripts = document.getElementsByTagName("script");
    // If `script` elements have the `readyState` property in this browser
    if ("readyState" in scripts[0]) {
      for (i = scripts.length; i--; ) {
        if (scripts[i].readyState === "interactive" && (jsPath = scripts[i].src)) {
          // Do nothing, assignment occurred during condition
          break;
        }
      }
    }
    // If the document is still parsing, then the last script in the document is the one that is currently loading
    else if (document.readyState === "loading") {
      jsPath = scripts[scripts.length - 1].src;
    }
    // If every `script` has a `src` attribute AND they all come from the same directory
    else {
      for (i = scripts.length; i--; ) {
        tmpJsPath = scripts[i].src;
        if (!tmpJsPath) {
          jsDir = null;
          break;
        }
        tmpJsPath = tmpJsPath.split("#")[0].split("?")[0];
        tmpJsPath = tmpJsPath.slice(0, tmpJsPath.lastIndexOf("/") + 1);
        if (jsDir == null) {
          jsDir = tmpJsPath;
        }
        else if (jsDir !== tmpJsPath) {
          jsDir = null;
          break;
        }
      }
      if (jsDir !== null) {
        jsPath = jsDir;
      }
    }
    // Otherwise we cannot reliably know what script is executing....
  }
  if (jsPath) {
    jsPath = jsPath.split("#")[0].split("?")[0];
    swfPath = jsPath.slice(0, jsPath.lastIndexOf("/") + 1) + swfPath;
  }
  return swfPath;
})();