<?php
/*
 * This file is part of the Microweber framework.
 *
 * (c) Microweber CMS LTD
 *
 * For full license information see
 * https://github.com/microweber/microweber/blob/master/LICENSE
 *
 */

namespace MicroweberPackages\Debugbar;

use Illuminate\Support\ServiceProvider;

class DebugbarServiceProvider extends ServiceProvider
{
    public function register()
    {

        /*
         * Sets third party service providers that are only needed on local/testing environments
         */
        if ($this->app->environment() != 'production') {
            /**
             * Loader for registering facades.
             */
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();

            if (class_exists('\Barryvdh\Debugbar\Facade', false)) {
                /*
                 * Load third party local providers
                 */
                $this->app->register(\Barryvdh\Debugbar\ServiceProvider::class);

                /*
                 * Load third party local aliases
                 */
                $loader->alias('Debugbar', \Barryvdh\Debugbar\Facade::class);
            }
        }
    }

    public function boot()
    {
        if (!\Config::get('debugbar.enabled')) {
            if (class_exists('\Debugbar', false)) {
                \Debugbar::disable();
            }
        }
    }
}
