/*
 *	jQuery elevateZoom 3.0.8
 *	Demo's and documentation:
 *	www.elevateweb.co.uk/image-zoom
 *
 *	Copyright (c) 2012 Andrew Eades
 *	www.elevateweb.co.uk
 *
 *	Dual licensed under the GPL and MIT licenses.
 *	http://en.wikipedia.org/wiki/MIT_License
 *	http://en.wikipedia.org/wiki/GNU_General_Public_License
 *

/*
 *	jQuery elevateZoom 3.0.3
 *	Demo's and documentation:
 *	www.elevateweb.co.uk/image-zoom
 *
 *	Copyright (c) 2012 Andrew Eades
 *	www.elevateweb.co.uk
 *
 *	Dual licensed under the GPL and MIT licenses.
 *	http://en.wikipedia.org/wiki/MIT_License
 *	http://en.wikipedia.org/wiki/GNU_General_Public_License
 */


if ( typeof Object.create !== 'function' ) {
	Object.create = function( obj ) {
		function F() {};
		F.prototype = obj;
		return new F();
	};
}

(function( $, window, document, undefined ) {
	var ElevateZoom = {
			init: function( options, elem ) {
				var self = this;

				self.elem = elem;
				self.$elem = $( elem );

				self.imageSrc = self.$elem.data("zoom-image") ? self.$elem.data("zoom-image") : self.$elem.attr("src");

				self.options = $.extend( {}, $.fn.elevateZoom.options, options );

				//TINT OVERRIDE SETTINGS
				if(self.options.tint) {
					self.options.lensColour = "none", //colour of the lens background
					self.options.lensOpacity =  "1" //opacity of the lens
				}
				//INNER OVERRIDE SETTINGS
				if(self.options.zoomType == "inner") {self.options.showLens = false;}


				//Remove alt on hover

				self.$elem.parent().removeAttr('title').removeAttr('alt');

				self.zoomImage = self.imageSrc;

				self.refresh( 1 );



				//Create the image swap from the gallery 
				$('#'+self.options.gallery + ' a').click( function(e) { 

					//Set a class on the currently active gallery image
					if(self.options.galleryActiveClass){
						$('#'+self.options.gallery + ' a').removeClass(self.options.galleryActiveClass);
						$(this).addClass(self.options.galleryActiveClass);
					}
					//stop any link on the a tag from working
					e.preventDefault();

					//call the swap image function            
					if($(this).data("zoom-image")){self.zoomImagePre = $(this).data("zoom-image")}
					else{self.zoomImagePre = $(this).data("image");}
					self.swaptheimage($(this).data("image"), self.zoomImagePre);
					return false;
				});

			},

			refresh: function( length ) {
				var self = this;

				setTimeout(function() {
					self.fetch(self.imageSrc);

				}, length || self.options.refresh );
			},

			fetch: function(imgsrc) {
				//get the image
				var self = this;
				var newImg = new Image();
				newImg.onload = function() {
					//set the large image dimensions - used to calculte ratio's
					self.largeWidth = newImg.width;
					self.largeHeight = newImg.height;
					//once image is loaded start the calls
					self.startZoom();
					self.currentImage = self.imageSrc;
					//let caller know image has been loaded
					self.options.onZoomedImageLoaded(self.$elem);
				}
				newImg.src = imgsrc; // this must be done AFTER setting onload

				return;

			},

			startZoom: function( ) {
				var self = this;
				//get dimensions of the non zoomed image
				self.nzWidth = self.$elem.width();
				self.nzHeight = self.$elem.height();

				//activated elements
				self.isWindowActive = false;
				self.isLensActive = false;
				self.isTintActive = false;
				self.overWindow = false;    

				//CrossFade Wrappe
				if(self.options.imageCrossfade){
					self.zoomWrap = self.$elem.wrap('<div style="height:'+self.nzHeight+'px;width:'+self.nzWidth+'px;" class="zoomWrapper" />');        
					self.$elem.css('position', 'absolute'); 
				}

				self.zoomLock = 1;
				self.scrollingLock = false;
				self.changeBgSize = false;
				self.currentZoomLevel = self.options.zoomLevel;


				//get offset of the non zoomed image
				self.nzOffset = self.$elem.offset();
				//calculate the width ratio of the large/small image
				self.widthRatio = (self.largeWidth/self.currentZoomLevel) / self.nzWidth;
				self.heightRatio = (self.largeHeight/self.currentZoomLevel) / self.nzHeight; 


				//if window zoom        
				if(self.options.zoomType == "window") {
					self.zoomWindowStyle = "overflow: hidden;"
						+ "background-position: 0px 0px;text-align:center;"  
						+ "background-color: " + String(self.options.zoomWindowBgColour)            
						+ ";width: " + String(self.options.zoomWindowWidth) + "px;"
						+ "height: " + String(self.options.zoomWindowHeight)
						+ "px;float: left;"
						+ "background-size: "+ self.largeWidth/self.currentZoomLevel+ "px " +self.largeHeight/self.currentZoomLevel + "px;"
						+ "display: none;z-index:100;"
						+ "border: " + String(self.options.borderSize) 
						+ "px solid " + self.options.borderColour 
						+ ";background-repeat: no-repeat;"
						+ "position: absolute;";
				}    


				//if inner  zoom    
				if(self.options.zoomType == "inner") {
					//has a border been put on the image? Lets cater for this

					var borderWidth = self.$elem.css("border-left-width");

					self.zoomWindowStyle = "overflow: hidden;"
						+ "margin-left: " + String(borderWidth) + ";" 
						+ "margin-top: " + String(borderWidth) + ";"         
						+ "background-position: 0px 0px;"
						+ "width: " + String(self.nzWidth) + "px;"
						+ "height: " + String(self.nzHeight) + "px;"
						+ "px;float: left;"
						+ "display: none;"
						+ "cursor:"+(self.options.cursor)+";"
						+ "px solid " + self.options.borderColour 
						+ ";background-repeat: no-repeat;"
						+ "position: absolute;";
				}    



				//lens style for window zoom
				if(self.options.zoomType == "window") {


					// adjust images less than the window height

					if(self.nzHeight < self.options.zoomWindowWidth/self.widthRatio){
						lensHeight = self.nzHeight;              
					}
					else{
						lensHeight = String((self.options.zoomWindowHeight/self.heightRatio))
					}
					if(self.largeWidth < self.options.zoomWindowWidth){
						lensWidth = self.nzWidth;
					}       
					else{
						lensWidth =  (self.options.zoomWindowWidth/self.widthRatio);
					}


					self.lensStyle = "background-position: 0px 0px;width: " + String((self.options.zoomWindowWidth)/self.widthRatio) + "px;height: " + String((self.options.zoomWindowHeight)/self.heightRatio)
					+ "px;float: right;display: none;"
					+ "overflow: hidden;"
					+ "z-index: 999;"   
					+ "-webkit-transform: translateZ(0);"               
					+ "opacity:"+(self.options.lensOpacity)+";filter: alpha(opacity = "+(self.options.lensOpacity*100)+"); zoom:1;"
					+ "width:"+lensWidth+"px;"
					+ "height:"+lensHeight+"px;"
					+ "background-color:"+(self.options.lensColour)+";"					
					+ "cursor:"+(self.options.cursor)+";"
					+ "border: "+(self.options.lensBorderSize)+"px" +
					" solid "+(self.options.lensBorderColour)+";background-repeat: no-repeat;position: absolute;";
				} 


				//tint style
				self.tintStyle = "display: block;"
					+ "position: absolute;"
					+ "background-color: "+self.options.tintColour+";"	
					+ "filter:alpha(opacity=0);"		
					+ "opacity: 0;"	
					+ "width: " + self.nzWidth + "px;"
					+ "height: " + self.nzHeight + "px;"

					;

				//lens style for lens zoom with optional round for modern browsers
				self.lensRound = '';

				if(self.options.zoomType == "lens") {

					self.lensStyle = "background-position: 0px 0px;"
						+ "float: left;display: none;"
						+ "border: " + String(self.options.borderSize) + "px solid " + self.options.borderColour+";"
						+ "width:"+ String(self.options.lensSize) +"px;"
						+ "height:"+ String(self.options.lensSize)+"px;"
						+ "background-repeat: no-repeat;position: absolute;";


				}


				//does not round in all browsers
				if(self.options.lensShape == "round") {
					self.lensRound = "border-top-left-radius: " + String(self.options.lensSize / 2 + self.options.borderSize) + "px;"
					+ "border-top-right-radius: " + String(self.options.lensSize / 2 + self.options.borderSize) + "px;"
					+ "border-bottom-left-radius: " + String(self.options.lensSize / 2 + self.options.borderSize) + "px;"
					+ "border-bottom-right-radius: " + String(self.options.lensSize / 2 + self.options.borderSize) + "px;";

				}

				//create the div's                                                + ""
				//self.zoomContainer = $('<div/>').addClass('zoomContainer').css({"position":"relative", "height":self.nzHeight, "width":self.nzWidth});

				self.zoomContainer = $('<div class="zoomContainer" style="-webkit-transform: translateZ(0);position:absolute;left:'+self.nzOffset.left+'px;top:'+self.nzOffset.top+'px;height:'+self.nzHeight+'px;width:'+self.nzWidth+'px;"></div>');
				$('body').append(self.zoomContainer);	


				//this will add overflow hidden and contrain the lens on lens mode       
				if(self.options.containLensZoom && self.options.zoomType == "lens"){
					self.zoomContainer.css("overflow", "hidden");
				}
				if(self.options.zoomType != "inner") {
					self.zoomLens = $("<div class='zoomLens' style='" + self.lensStyle + self.lensRound +"'>&nbsp;</div>")
					.appendTo(self.zoomContainer)
					.click(function () {
						self.$elem.trigger('click');
					});


					if(self.options.tint) {
						self.tintContainer = $('<div/>').addClass('tintContainer');	
						self.zoomTint = $("<div class='zoomTint' style='"+self.tintStyle+"'></div>");


						self.zoomLens.wrap(self.tintContainer);


						self.zoomTintcss = self.zoomLens.after(self.zoomTint);	

						//if tint enabled - set an image to show over the tint

						self.zoomTintImage = $('<img style="position: absolute; left: 0px; top: 0px; max-width: none; width: '+self.nzWidth+'px; height: '+self.nzHeight+'px;" src="'+self.imageSrc+'">')
						.appendTo(self.zoomLens)
						.click(function () {

							self.$elem.trigger('click');
						});

					}          

				}







				//create zoom window 
				if(isNaN(self.options.zoomWindowPosition)){
					self.zoomWindow = $("<div style='z-index:999;left:"+(self.windowOffsetLeft)+"px;top:"+(self.windowOffsetTop)+"px;" + self.zoomWindowStyle + "' class='zoomWindow'>&nbsp;</div>")
					.appendTo('body')
					.click(function () {
						self.$elem.trigger('click');
					});
				}else{
					self.zoomWindow = $("<div style='z-index:999;left:"+(self.windowOffsetLeft)+"px;top:"+(self.windowOffsetTop)+"px;" + self.zoomWindowStyle + "' class='zoomWindow'>&nbsp;</div>")
					.appendTo(self.zoomContainer)
					.click(function () {
						self.$elem.trigger('click');
					});
				}              
				self.zoomWindowContainer = $('<div/>').addClass('zoomWindowContainer').css("width",self.options.zoomWindowWidth);
				self.zoomWindow.wrap(self.zoomWindowContainer);


				//  self.captionStyle = "text-align: left;background-color: black;color: white;font-weight: bold;padding: 10px;font-family: sans-serif;font-size: 11px";                                                                                                                                                                                                                                          
				// self.zoomCaption = $('<div class="elevatezoom-caption" style="'+self.captionStyle+'display: block; width: 280px;">INSERT ALT TAG</div>').appendTo(self.zoomWindow.parent());

				if(self.options.zoomType == "lens") {
					self.zoomLens.css({ backgroundImage: "url('" + self.imageSrc + "')" }); 
				}
				if(self.options.zoomType == "window") {
					self.zoomWindow.css({ backgroundImage: "url('" + self.imageSrc + "')" }); 
				}
				if(self.options.zoomType == "inner") {
					self.zoomWindow.css({ backgroundImage: "url('" + self.imageSrc + "')" }); 
				}
				/*-------------------END THE ZOOM WINDOW AND LENS----------------------------------*/
				//touch events
				self.$elem.bind('touchmove', function(e){    
					e.preventDefault();
					var touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];  
					self.setPosition(touch);

				});  
				self.zoomContainer.bind('touchmove', function(e){ 
					if(self.options.zoomType == "inner") {
						self.showHideWindow("show");

					}
					e.preventDefault();
					var touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];  
					self.setPosition(touch); 

				});  	
				self.zoomContainer.bind('touchend', function(e){ 
					self.showHideWindow("hide");
					if(self.options.showLens) {self.showHideLens("hide");}
					if(self.options.tint && self.options.zoomType != "inner") {self.showHideTint("hide");}
				});  	

				self.$elem.bind('touchend', function(e){ 
					self.showHideWindow("hide");
					if(self.options.showLens) {self.showHideLens("hide");}
					if(self.options.tint && self.options.zoomType != "inner") {self.showHideTint("hide");}
				});  	
				if(self.options.showLens) {
					self.zoomLens.bind('touchmove', function(e){ 

						e.preventDefault();
						var touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];  
						self.setPosition(touch); 
					});    


					self.zoomLens.bind('touchend', function(e){ 
						self.showHideWindow("hide");
						if(self.options.showLens) {self.showHideLens("hide");}
						if(self.options.tint && self.options.zoomType != "inner") {self.showHideTint("hide");}
					});  
				}
				//Needed to work in IE
				self.$elem.bind('mousemove', function(e){   
					if(self.overWindow == false){self.setElements("show");}
					//make sure on orientation change the setposition is not fired
					if(self.lastX !== e.clientX || self.lastY !== e.clientY){
						self.setPosition(e);
						self.currentLoc = e;
					}   
					self.lastX = e.clientX;
					self.lastY = e.clientY;    

				});  	

				self.zoomContainer.bind('mousemove', function(e){ 

					if(self.overWindow == false){self.setElements("show");} 

					//make sure on orientation change the setposition is not fired 
					if(self.lastX !== e.clientX || self.lastY !== e.clientY){
						self.setPosition(e);
						self.currentLoc = e;
					}   
					self.lastX = e.clientX;
					self.lastY = e.clientY;    
				});  	
				if(self.options.zoomType != "inner") {
					self.zoomLens.bind('mousemove', function(e){      
						//make sure on orientation change the setposition is not fired
						if(self.lastX !== e.clientX || self.lastY !== e.clientY){
							self.setPosition(e);
							self.currentLoc = e;
						}   
						self.lastX = e.clientX;
						self.lastY = e.clientY;    
					});
				}
				if(self.options.tint && self.options.zoomType != "inner") {
					self.zoomTint.bind('mousemove', function(e){ 
						//make sure on orientation change the setposition is not fired
						if(self.lastX !== e.clientX || self.lastY !== e.clientY){
							self.setPosition(e);
							self.currentLoc = e;
						}   
						self.lastX = e.clientX;
						self.lastY = e.clientY;    
					});

				}
				if(self.options.zoomType == "inner") {
					self.zoomWindow.bind('mousemove', function(e) {
						//self.overWindow = true;
						//make sure on orientation change the setposition is not fired
						if(self.lastX !== e.clientX || self.lastY !== e.clientY){
							self.setPosition(e);
							self.currentLoc = e;
						}   
						self.lastX = e.clientX;
						self.lastY = e.clientY;    
					});

				}


				//  lensFadeOut: 500,  zoomTintFadeIn
				self.zoomContainer.add(self.$elem).mouseenter(function(){

					if(self.overWindow == false){self.setElements("show");} 


				}).mouseleave(function(){
					if(!self.scrollLock){
						self.setElements("hide");
            self.options.onDestroy(self.$elem);
					}
				});
				//end ove image





				if(self.options.zoomType != "inner") {
					self.zoomWindow.mouseenter(function(){
						self.overWindow = true;   
						self.setElements("hide");                  
					}).mouseleave(function(){

						self.overWindow = false;
					});
				}
				//end ove image



//				var delta = parseInt(e.originalEvent.wheelDelta || -e.originalEvent.detail);

				//      $(this).empty();    
				//    return false;

				//fix for initial zoom setting
				if (self.options.zoomLevel != 1){
					//	self.changeZoomLevel(self.currentZoomLevel);
				}
				//set the min zoomlevel
				if(self.options.minZoomLevel){
					self.minZoomLevel = self.options.minZoomLevel;
				}
				else{
					self.minZoomLevel = self.options.scrollZoomIncrement * 2;
				}


				if(self.options.scrollZoom){


					self.zoomContainer.add(self.$elem).bind('mousewheel DOMMouseScroll MozMousePixelScroll', function(e){


//						in IE there is issue with firing of mouseleave - So check whether still scrolling
//						and on mouseleave check if scrolllock          
						self.scrollLock = true;
						clearTimeout($.data(this, 'timer'));
						$.data(this, 'timer', setTimeout(function() {
							self.scrollLock = false;
							//do something
						}, 250));

						var theEvent = e.originalEvent.wheelDelta || e.originalEvent.detail*-1


						//this.scrollTop += ( delta < 0 ? 1 : -1 ) * 30;
						//   e.preventDefault();


						e.stopImmediatePropagation();
						e.stopPropagation();
						e.preventDefault();


						if(theEvent /120 > 0) {
							//scrolling up
							if(self.currentZoomLevel >= self.minZoomLevel){ 
								self.changeZoomLevel(self.currentZoomLevel-self.options.scrollZoomIncrement);        
							}

						}
						else{
							//scrolling down


							if(self.options.maxZoomLevel){
								if(self.currentZoomLevel <= self.options.maxZoomLevel){           
									self.changeZoomLevel(parseFloat(self.currentZoomLevel)+self.options.scrollZoomIncrement);
								}
							}
							else{
								//andy 

								self.changeZoomLevel(parseFloat(self.currentZoomLevel)+self.options.scrollZoomIncrement);
							}

						}
						return false;
					});
				}


			},
			setElements: function(type) {
				var self = this;
        if(!self.options.zoomEnabled){return false;}
				if(type=="show"){
					if(self.isWindowSet){
						if(self.options.zoomType == "inner") {self.showHideWindow("show");}
						if(self.options.zoomType == "window") {self.showHideWindow("show");}
						if(self.options.showLens) {self.showHideLens("show");}
						if(self.options.tint && self.options.zoomType != "inner") {self.showHideTint("show");
						}
					}
				}

				if(type=="hide"){
					if(self.options.zoomType == "window") {self.showHideWindow("hide");}
					if(!self.options.tint) {self.showHideWindow("hide");}
					if(self.options.showLens) {self.showHideLens("hide");}
					if(self.options.tint) {	self.showHideTint("hide");}
				}   
			},
			setPosition: function(e) {
      
				var self = this;
        
        if(!self.options.zoomEnabled){return false;}

				//recaclc offset each time in case the image moves
				//this can be caused by other on page elements
				self.nzHeight = self.$elem.height();
				self.nzWidth = self.$elem.width();
				self.nzOffset = self.$elem.offset();

				if(self.options.tint && self.options.zoomType != "inner") {
					self.zoomTint.css({ top: 0});
					self.zoomTint.css({ left: 0});
				}
				//set responsive       
				//will checking if the image needs changing before running this code work faster?
				if(self.options.responsive && !self.options.scrollZoom){
					if(self.options.showLens){ 
						if(self.nzHeight < self.options.zoomWindowWidth/self.widthRatio){
							lensHeight = self.nzHeight;              
						}
						else{
							lensHeight = String((self.options.zoomWindowHeight/self.heightRatio))
						}
						if(self.largeWidth < self.options.zoomWindowWidth){
							lensWidth = self.nzWidth;
						}       
						else{
							lensWidth =  (self.options.zoomWindowWidth/self.widthRatio);
						}
						self.widthRatio = self.largeWidth / self.nzWidth;
						self.heightRatio = self.largeHeight / self.nzHeight;        
						if(self.options.zoomType != "lens") {


							//possibly dont need to keep recalcalculating
							//if the lens is heigher than the image, then set lens size to image size
							if(self.nzHeight < self.options.zoomWindowWidth/self.widthRatio){
								lensHeight = self.nzHeight;  

							}
							else{
								lensHeight = String((self.options.zoomWindowHeight/self.heightRatio))
							}

							if(self.nzWidth < self.options.zoomWindowHeight/self.heightRatio){
								lensWidth = self.nzWidth;
							}       
							else{
								lensWidth =  String((self.options.zoomWindowWidth/self.widthRatio));
							}            

							self.zoomLens.css('width', lensWidth);    
							self.zoomLens.css('height', lensHeight); 

							if(self.options.tint){    
								self.zoomTintImage.css('width', self.nzWidth);    
								self.zoomTintImage.css('height', self.nzHeight); 
							}

						}                     
						if(self.options.zoomType == "lens") {  

							self.zoomLens.css({ width: String(self.options.lensSize) + 'px', height: String(self.options.lensSize) + 'px' })      


						}        
						//end responsive image change
					}
				}

				//container fix
				self.zoomContainer.css({ top: self.nzOffset.top});
				self.zoomContainer.css({ left: self.nzOffset.left});
				self.mouseLeft = parseInt(e.pageX - self.nzOffset.left);
				self.mouseTop = parseInt(e.pageY - self.nzOffset.top);
				//calculate the Location of the Lens

				//calculate the bound regions - but only if zoom window
				if(self.options.zoomType == "window") {
					self.Etoppos = (self.mouseTop < (self.zoomLens.height()/2));
					self.Eboppos = (self.mouseTop > self.nzHeight - (self.zoomLens.height()/2)-(self.options.lensBorderSize*2));
					self.Eloppos = (self.mouseLeft < 0+((self.zoomLens.width()/2))); 
					self.Eroppos = (self.mouseLeft > (self.nzWidth - (self.zoomLens.width()/2)-(self.options.lensBorderSize*2)));  
				}
				//calculate the bound regions - but only for inner zoom
				if(self.options.zoomType == "inner"){ 
					self.Etoppos = (self.mouseTop < ((self.nzHeight/2)/self.heightRatio) );
					self.Eboppos = (self.mouseTop > (self.nzHeight - ((self.nzHeight/2)/self.heightRatio)));
					self.Eloppos = (self.mouseLeft < 0+(((self.nzWidth/2)/self.widthRatio)));
					self.Eroppos = (self.mouseLeft > (self.nzWidth - (self.nzWidth/2)/self.widthRatio-(self.options.lensBorderSize*2)));  
				}

				// if the mouse position of the slider is one of the outerbounds, then hide  window and lens
				if (self.mouseLeft < 0 || self.mouseTop < 0 || self.mouseLeft > self.nzWidth || self.mouseTop > self.nzHeight ) {				          
					self.setElements("hide");
					return;
				}
				//else continue with operations
				else {


					//lens options
					if(self.options.showLens) {
						//		self.showHideLens("show");
						//set background position of lens
						self.lensLeftPos = String(Math.floor(self.mouseLeft - self.zoomLens.width() / 2));
						self.lensTopPos = String(Math.floor(self.mouseTop - self.zoomLens.height() / 2));


					}
					//adjust the background position if the mouse is in one of the outer regions 

					//Top region
					if(self.Etoppos){
						self.lensTopPos = 0;
					}
					//Left Region
					if(self.Eloppos){
						self.windowLeftPos = 0;
						self.lensLeftPos = 0;
						self.tintpos=0;
					}     
					//Set bottom and right region for window mode
					if(self.options.zoomType == "window") {
						if(self.Eboppos){
							self.lensTopPos = Math.max( (self.nzHeight)-self.zoomLens.height()-(self.options.lensBorderSize*2), 0 );
						} 
						if(self.Eroppos){
							self.lensLeftPos = (self.nzWidth-(self.zoomLens.width())-(self.options.lensBorderSize*2));
						}  
					}  
					//Set bottom and right region for inner mode
					if(self.options.zoomType == "inner") {
						if(self.Eboppos){
							self.lensTopPos = Math.max( ((self.nzHeight)-(self.options.lensBorderSize*2)), 0 );
						} 
						if(self.Eroppos){
							self.lensLeftPos = (self.nzWidth-(self.nzWidth)-(self.options.lensBorderSize*2));
						}  

					}
					//if lens zoom
					if(self.options.zoomType == "lens") {  
						self.windowLeftPos = String(((e.pageX - self.nzOffset.left) * self.widthRatio - self.zoomLens.width() / 2) * (-1));   
						self.windowTopPos = String(((e.pageY - self.nzOffset.top) * self.heightRatio - self.zoomLens.height() / 2) * (-1));

						self.zoomLens.css({ backgroundPosition: self.windowLeftPos + 'px ' + self.windowTopPos + 'px' });

						if(self.changeBgSize){  

							if(self.nzHeight>self.nzWidth){  
								if(self.options.zoomType == "lens"){       
									self.zoomLens.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
								}   

								self.zoomWindow.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
							}
							else{     
								if(self.options.zoomType == "lens"){       
									self.zoomLens.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });
								}   
								self.zoomWindow.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });            
							}
							self.changeBgSize = false;
						}    

						self.setWindowPostition(e);  
					}
					//if tint zoom   
					if(self.options.tint && self.options.zoomType != "inner") {
						self.setTintPosition(e);

					}
					//set the css background position 
					if(self.options.zoomType == "window") {
						self.setWindowPostition(e);   
					}
					if(self.options.zoomType == "inner") {
						self.setWindowPostition(e);   
					}
					if(self.options.showLens) {

						if(self.fullwidth && self.options.zoomType != "lens"){
							self.lensLeftPos = 0;

						}
						self.zoomLens.css({ left: self.lensLeftPos + 'px', top: self.lensTopPos + 'px' })  
					}

				} //end else



			},
			showHideWindow: function(change) {
				var self = this;              
				if(change == "show"){      
					if(!self.isWindowActive){
						if(self.options.zoomWindowFadeIn){
							self.zoomWindow.stop(true, true, false).fadeIn(self.options.zoomWindowFadeIn);
						}
						else{self.zoomWindow.show();}
						self.isWindowActive = true;
					}            
				}
				if(change == "hide"){
					if(self.isWindowActive){
						if(self.options.zoomWindowFadeOut){
							self.zoomWindow.stop(true, true).fadeOut(self.options.zoomWindowFadeOut, function () {
								if (self.loop) {
									//stop moving the zoom window when zoom window is faded out
									clearInterval(self.loop);
									self.loop = false;
								}
							});
						}
						else{self.zoomWindow.hide();}
						self.isWindowActive = false;        
					}      
				}
			},
			showHideLens: function(change) {
				var self = this;              
				if(change == "show"){      
					if(!self.isLensActive){
						if(self.options.lensFadeIn){
							self.zoomLens.stop(true, true, false).fadeIn(self.options.lensFadeIn);
						}
						else{self.zoomLens.show();}
						self.isLensActive = true;
					}            
				}
				if(change == "hide"){
					if(self.isLensActive){
						if(self.options.lensFadeOut){
							self.zoomLens.stop(true, true).fadeOut(self.options.lensFadeOut);
						}
						else{self.zoomLens.hide();}
						self.isLensActive = false;        
					}      
				}
			},
			showHideTint: function(change) {
				var self = this;              
				if(change == "show"){      
					if(!self.isTintActive){

						if(self.options.zoomTintFadeIn){
							self.zoomTint.css({opacity:self.options.tintOpacity}).animate().stop(true, true).fadeIn("slow");
						}
						else{
							self.zoomTint.css({opacity:self.options.tintOpacity}).animate();
							self.zoomTint.show();


						}
						self.isTintActive = true;
					}            
				}
				if(change == "hide"){      
					if(self.isTintActive){ 

						if(self.options.zoomTintFadeOut){
							self.zoomTint.stop(true, true).fadeOut(self.options.zoomTintFadeOut);
						}
						else{self.zoomTint.hide();}
						self.isTintActive = false;        
					}      
				}
			},
			setLensPostition: function( e ) {


			},
			setWindowPostition: function( e ) {
				//return obj.slice( 0, count );
				var self = this;

				if(!isNaN(self.options.zoomWindowPosition)){

					switch (self.options.zoomWindowPosition) { 
					case 1: //done         
						self.windowOffsetTop = (self.options.zoomWindowOffety);//DONE - 1
						self.windowOffsetLeft =(+self.nzWidth); //DONE 1, 2, 3, 4, 16
						break;
					case 2:
						if(self.options.zoomWindowHeight > self.nzHeight){ //positive margin

							self.windowOffsetTop = ((self.options.zoomWindowHeight/2)-(self.nzHeight/2))*(-1);
							self.windowOffsetLeft =(self.nzWidth); //DONE 1, 2, 3, 4, 16
						}
						else{ //negative margin

						}
						break;
					case 3: //done        
						self.windowOffsetTop = (self.nzHeight - self.zoomWindow.height() - (self.options.borderSize*2)); //DONE 3,9
						self.windowOffsetLeft =(self.nzWidth); //DONE 1, 2, 3, 4, 16
						break;      
					case 4: //done  
						self.windowOffsetTop = (self.nzHeight); //DONE - 4,5,6,7,8
						self.windowOffsetLeft =(self.nzWidth); //DONE 1, 2, 3, 4, 16
						break;
					case 5: //done  
						self.windowOffsetTop = (self.nzHeight); //DONE - 4,5,6,7,8
						self.windowOffsetLeft =(self.nzWidth-self.zoomWindow.width()-(self.options.borderSize*2)); //DONE - 5,15
						break;
					case 6: 
						if(self.options.zoomWindowHeight > self.nzHeight){ //positive margin
							self.windowOffsetTop = (self.nzHeight);  //DONE - 4,5,6,7,8

							self.windowOffsetLeft =((self.options.zoomWindowWidth/2)-(self.nzWidth/2)+(self.options.borderSize*2))*(-1);  
						}
						else{ //negative margin

						}


						break;
					case 7: //done  
						self.windowOffsetTop = (self.nzHeight);  //DONE - 4,5,6,7,8
						self.windowOffsetLeft = 0; //DONE 7, 13
						break;
					case 8: //done  
						self.windowOffsetTop = (self.nzHeight); //DONE - 4,5,6,7,8
						self.windowOffsetLeft =(self.zoomWindow.width()+(self.options.borderSize*2) )* (-1);  //DONE 8,9,10,11,12
						break;
					case 9:  //done  
						self.windowOffsetTop = (self.nzHeight - self.zoomWindow.height() - (self.options.borderSize*2)); //DONE 3,9
						self.windowOffsetLeft =(self.zoomWindow.width()+(self.options.borderSize*2) )* (-1);  //DONE 8,9,10,11,12
						break;
					case 10: 
						if(self.options.zoomWindowHeight > self.nzHeight){ //positive margin

							self.windowOffsetTop = ((self.options.zoomWindowHeight/2)-(self.nzHeight/2))*(-1);
							self.windowOffsetLeft =(self.zoomWindow.width()+(self.options.borderSize*2) )* (-1);  //DONE 8,9,10,11,12
						}
						else{ //negative margin

						}
						break;
					case 11: 
						self.windowOffsetTop = (self.options.zoomWindowOffety);
						self.windowOffsetLeft =(self.zoomWindow.width()+(self.options.borderSize*2) )* (-1);  //DONE 8,9,10,11,12
						break;
					case 12: //done  
						self.windowOffsetTop = (self.zoomWindow.height()+(self.options.borderSize*2))*(-1); //DONE 12,13,14,15,16
						self.windowOffsetLeft =(self.zoomWindow.width()+(self.options.borderSize*2) )* (-1);  //DONE 8,9,10,11,12
						break;
					case 13: //done  
						self.windowOffsetTop = (self.zoomWindow.height()+(self.options.borderSize*2))*(-1); //DONE 12,13,14,15,16
						self.windowOffsetLeft =(0); //DONE 7, 13
						break;
					case 14: 
						if(self.options.zoomWindowHeight > self.nzHeight){ //positive margin
							self.windowOffsetTop = (self.zoomWindow.height()+(self.options.borderSize*2))*(-1); //DONE 12,13,14,15,16

							self.windowOffsetLeft =((self.options.zoomWindowWidth/2)-(self.nzWidth/2)+(self.options.borderSize*2))*(-1);  
						}
						else{ //negative margin

						}

						break;
					case 15://done   
						self.windowOffsetTop = (self.zoomWindow.height()+(self.options.borderSize*2))*(-1); //DONE 12,13,14,15,16
						self.windowOffsetLeft =(self.nzWidth-self.zoomWindow.width()-(self.options.borderSize*2)); //DONE - 5,15
						break;
					case 16:  //done  
						self.windowOffsetTop = (self.zoomWindow.height()+(self.options.borderSize*2))*(-1); //DONE 12,13,14,15,16
						self.windowOffsetLeft =(self.nzWidth); //DONE 1, 2, 3, 4, 16
						break;            
					default: //done  
						self.windowOffsetTop = (self.options.zoomWindowOffety);//DONE - 1
					self.windowOffsetLeft =(self.nzWidth); //DONE 1, 2, 3, 4, 16
					} 
				} //end isNAN
				else{
					//WE CAN POSITION IN A CLASS - ASSUME THAT ANY STRING PASSED IS
					self.externalContainer = $('#'+self.options.zoomWindowPosition);
					self.externalContainerWidth = self.externalContainer.width();
					self.externalContainerHeight = self.externalContainer.height();
					self.externalContainerOffset = self.externalContainer.offset();

					self.windowOffsetTop = self.externalContainerOffset.top;//DONE - 1
					self.windowOffsetLeft =self.externalContainerOffset.left; //DONE 1, 2, 3, 4, 16

				}
				self.isWindowSet = true;
				self.windowOffsetTop = self.windowOffsetTop + self.options.zoomWindowOffety;
				self.windowOffsetLeft = self.windowOffsetLeft + self.options.zoomWindowOffetx;

				self.zoomWindow.css({ top: self.windowOffsetTop});
				self.zoomWindow.css({ left: self.windowOffsetLeft});

				if(self.options.zoomType == "inner") {
					self.zoomWindow.css({ top: 0});
					self.zoomWindow.css({ left: 0});

				}   


				self.windowLeftPos = String(((e.pageX - self.nzOffset.left) * self.widthRatio - self.zoomWindow.width() / 2) * (-1));   
				self.windowTopPos = String(((e.pageY - self.nzOffset.top) * self.heightRatio - self.zoomWindow.height() / 2) * (-1));
				if(self.Etoppos){self.windowTopPos = 0;}
				if(self.Eloppos){self.windowLeftPos = 0;}     
				if(self.Eboppos){self.windowTopPos = (self.largeHeight/self.currentZoomLevel-self.zoomWindow.height())*(-1);  } 
				if(self.Eroppos){self.windowLeftPos = ((self.largeWidth/self.currentZoomLevel-self.zoomWindow.width())*(-1));}    

				//stops micro movements
				if(self.fullheight){
					self.windowTopPos = 0;

				}
				if(self.fullwidth){
					self.windowLeftPos = 0;

				}
				//set the css background position 


				if(self.options.zoomType == "window" || self.options.zoomType == "inner") {

					if(self.zoomLock == 1){
						//overrides for images not zoomable
						if(self.widthRatio <= 1){

							self.windowLeftPos = 0;
						}
						if(self.heightRatio <= 1){ 
							self.windowTopPos = 0;
						}
					}
					// adjust images less than the window height

					if (self.options.zoomType == "window") {
						if (self.largeHeight < self.options.zoomWindowHeight) {

							self.windowTopPos = 0;
						}
						if (self.largeWidth < self.options.zoomWindowWidth) {
							self.windowLeftPos = 0;
						}
					}

					//set the zoomwindow background position
					if (self.options.easing){

						//     if(self.changeZoom){
						//           clearInterval(self.loop);
						//           self.changeZoom = false;
						//           self.loop = false;

						//            }
						//set the pos to 0 if not set
						if(!self.xp){self.xp = 0;}
						if(!self.yp){self.yp = 0;}  
						//if loop not already started, then run it 
						if (!self.loop){           
							self.loop = setInterval(function(){                
								//using zeno's paradox    

								self.xp += (self.windowLeftPos  - self.xp) / self.options.easingAmount; 
								self.yp += (self.windowTopPos  - self.yp) / self.options.easingAmount;
								if(self.scrollingLock){


									clearInterval(self.loop);
									self.xp = self.windowLeftPos;
									self.yp = self.windowTopPos            

									self.xp = ((e.pageX - self.nzOffset.left) * self.widthRatio - self.zoomWindow.width() / 2) * (-1);
									self.yp = (((e.pageY - self.nzOffset.top) * self.heightRatio - self.zoomWindow.height() / 2) * (-1));                         

									if(self.changeBgSize){    
										if(self.nzHeight>self.nzWidth){  
											if(self.options.zoomType == "lens"){      
												self.zoomLens.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
											}   
											self.zoomWindow.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
										}
										else{   
											if(self.options.zoomType != "lens"){      
												self.zoomLens.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
											}            
											self.zoomWindow.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });            

										}

										/*
             if(!self.bgxp){self.bgxp = self.largeWidth/self.newvalue;}
						if(!self.bgyp){self.bgyp = self.largeHeight/self.newvalue ;}  
                 if (!self.bgloop){   
                 	self.bgloop = setInterval(function(){   

                 self.bgxp += (self.largeWidth/self.newvalue  - self.bgxp) / self.options.easingAmount; 
								self.bgyp += (self.largeHeight/self.newvalue  - self.bgyp) / self.options.easingAmount;

           self.zoomWindow.css({ "background-size": self.bgxp + 'px ' + self.bgyp + 'px' });


                  }, 16);

                 }
										 */
										self.changeBgSize = false;
									}

									self.zoomWindow.css({ backgroundPosition: self.windowLeftPos + 'px ' + self.windowTopPos + 'px' });
									self.scrollingLock = false;
									self.loop = false;

								}
								else if (Math.round(Math.abs(self.xp - self.windowLeftPos) + Math.abs(self.yp - self.windowTopPos)) < 1) {
									//stops micro movements
									clearInterval(self.loop);
									self.zoomWindow.css({ backgroundPosition: self.windowLeftPos + 'px ' + self.windowTopPos + 'px' });
									self.loop = false;
								}
								else{
									if(self.changeBgSize){    
										if(self.nzHeight>self.nzWidth){ 
											if(self.options.zoomType == "lens"){      
												self.zoomLens.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
											}         
											self.zoomWindow.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
										}
										else{                 
											if(self.options.zoomType != "lens"){     
												self.zoomLens.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });
											}      
											self.zoomWindow.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });            
										}
										self.changeBgSize = false;
									}                   

									self.zoomWindow.css({ backgroundPosition: self.xp + 'px ' + self.yp + 'px' });
								}       
							}, 16);
						}
					}   
					else{    
						if(self.changeBgSize){  
							if(self.nzHeight>self.nzWidth){  
								if(self.options.zoomType == "lens"){      
									self.zoomLens.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
								} 

								self.zoomWindow.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });
							}
							else{     
								if(self.options.zoomType == "lens"){      
									self.zoomLens.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });
								} 
								if((self.largeHeight/self.newvaluewidth) < self.options.zoomWindowHeight){ 

									self.zoomWindow.css({ "background-size": self.largeWidth/self.newvaluewidth + 'px ' + self.largeHeight/self.newvaluewidth + 'px' });            
								}
								else{

									self.zoomWindow.css({ "background-size": self.largeWidth/self.newvalueheight + 'px ' + self.largeHeight/self.newvalueheight + 'px' });   
								}

							}
							self.changeBgSize = false;
						}     

						self.zoomWindow.css({ backgroundPosition: self.windowLeftPos + 'px ' + self.windowTopPos + 'px' });       
					}
				} 
			},
			setTintPosition: function(e){
				var self = this;
				self.nzOffset = self.$elem.offset();
				self.tintpos = String(((e.pageX - self.nzOffset.left)-(self.zoomLens.width() / 2)) * (-1)); 
				self.tintposy = String(((e.pageY - self.nzOffset.top) - self.zoomLens.height() / 2) * (-1));	
				if(self.Etoppos){
					self.tintposy = 0;
				}
				if(self.Eloppos){
					self.tintpos=0;
				}     
				if(self.Eboppos){
					self.tintposy = (self.nzHeight-self.zoomLens.height()-(self.options.lensBorderSize*2))*(-1);
				} 
				if(self.Eroppos){
					self.tintpos = ((self.nzWidth-self.zoomLens.width()-(self.options.lensBorderSize*2))*(-1));
				}    
				if(self.options.tint) {
					//stops micro movements
					if(self.fullheight){
						self.tintposy = 0;

					}
					if(self.fullwidth){ 
						self.tintpos = 0;

					}   
					self.zoomTintImage.css({'left': self.tintpos+'px'});
					self.zoomTintImage.css({'top': self.tintposy+'px'});
				}
			},

			swaptheimage: function(smallimage, largeimage){
				var self = this;
				var newImg = new Image(); 

				if(self.options.loadingIcon){
					self.spinner = $('<div style="background: url(\''+self.options.loadingIcon+'\') no-repeat center;height:'+self.nzHeight+'px;width:'+self.nzWidth+'px;z-index: 2000;position: absolute; background-position: center center;"></div>');
					self.$elem.after(self.spinner);
				}

				self.options.onImageSwap(self.$elem);

				newImg.onload = function() {
					self.largeWidth = newImg.width;
					self.largeHeight = newImg.height;
					self.zoomImage = largeimage;
					self.zoomWindow.css({ "background-size": self.largeWidth + 'px ' + self.largeHeight + 'px' });
					self.swapAction(smallimage, largeimage);
					return;              
				}          
				newImg.src = largeimage; // this must be done AFTER setting onload

			},
			swapAction: function(smallimage, largeimage){


				var self = this;    

				var newImg2 = new Image(); 
				newImg2.onload = function() {
					//re-calculate values
					self.nzHeight = newImg2.height;
					self.nzWidth = newImg2.width;
					self.options.onImageSwapComplete(self.$elem);

					self.doneCallback();  
					return;      
				}          
				newImg2.src = smallimage; 

				//reset the zoomlevel to that initially set in options
				self.currentZoomLevel = self.options.zoomLevel;
				self.options.maxZoomLevel = false;

				//swaps the main image
				//self.$elem.attr("src",smallimage);
				//swaps the zoom image     
				if(self.options.zoomType == "lens") {
					self.zoomLens.css({ backgroundImage: "url('" + largeimage + "')" }); 
				}
				if(self.options.zoomType == "window") {
					self.zoomWindow.css({ backgroundImage: "url('" + largeimage + "')" }); 
				}
				if(self.options.zoomType == "inner") {
					self.zoomWindow.css({ backgroundImage: "url('" + largeimage + "')" }); 
				} 



				self.currentImage = largeimage;

				if(self.options.imageCrossfade){
					var oldImg = self.$elem;
					var newImg = oldImg.clone();         
					self.$elem.attr("src",smallimage)
					self.$elem.after(newImg);
					newImg.stop(true).fadeOut(self.options.imageCrossfade, function() {
						$(this).remove();         
					});

					//       				if(self.options.zoomType == "inner"){
					//remove any attributes on the cloned image so we can resize later
					self.$elem.width("auto").removeAttr("width");
					self.$elem.height("auto").removeAttr("height");
					//   }

					oldImg.fadeIn(self.options.imageCrossfade);

					if(self.options.tint && self.options.zoomType != "inner") {

						var oldImgTint = self.zoomTintImage;
						var newImgTint = oldImgTint.clone();         
						self.zoomTintImage.attr("src",largeimage)
						self.zoomTintImage.after(newImgTint);
						newImgTint.stop(true).fadeOut(self.options.imageCrossfade, function() {
							$(this).remove();         
						});



						oldImgTint.fadeIn(self.options.imageCrossfade);


						//self.zoomTintImage.attr("width",elem.data("image"));

						//resize the tint window
						self.zoomTint.css({ height: self.$elem.height()});
						self.zoomTint.css({ width: self.$elem.width()});
					}    

					self.zoomContainer.css("height", self.$elem.height());
					self.zoomContainer.css("width", self.$elem.width());

					if(self.options.zoomType == "inner"){ 
						if(!self.options.constrainType){
							self.zoomWrap.parent().css("height", self.$elem.height());
							self.zoomWrap.parent().css("width", self.$elem.width());

							self.zoomWindow.css("height", self.$elem.height());
							self.zoomWindow.css("width", self.$elem.width());
						}
					} 

					if(self.options.imageCrossfade){  
						self.zoomWrap.css("height", self.$elem.height());
						self.zoomWrap.css("width", self.$elem.width());
					} 
				}
				else{
					self.$elem.attr("src",smallimage); 
					if(self.options.tint) {
						self.zoomTintImage.attr("src",largeimage);
						//self.zoomTintImage.attr("width",elem.data("image"));
						self.zoomTintImage.attr("height",self.$elem.height());
						//self.zoomTintImage.attr('src') = elem.data("image");
						self.zoomTintImage.css({ height: self.$elem.height()}); 
						self.zoomTint.css({ height: self.$elem.height()});

					}
					self.zoomContainer.css("height", self.$elem.height());
					self.zoomContainer.css("width", self.$elem.width());

					if(self.options.imageCrossfade){  
						self.zoomWrap.css("height", self.$elem.height());
						self.zoomWrap.css("width", self.$elem.width());
					} 
				}              
				if(self.options.constrainType){     

					//This will contrain the image proportions
					if(self.options.constrainType == "height"){ 

						self.zoomContainer.css("height", self.options.constrainSize);
						self.zoomContainer.css("width", "auto");

						if(self.options.imageCrossfade){  
							self.zoomWrap.css("height", self.options.constrainSize);
							self.zoomWrap.css("width", "auto"); 
							self.constwidth = self.zoomWrap.width();


						}
						else{                  
							self.$elem.css("height", self.options.constrainSize);
							self.$elem.css("width", "auto");
							self.constwidth = self.$elem.width();
						} 

						if(self.options.zoomType == "inner"){

							self.zoomWrap.parent().css("height", self.options.constrainSize);
							self.zoomWrap.parent().css("width", self.constwidth);   
							self.zoomWindow.css("height", self.options.constrainSize);
							self.zoomWindow.css("width", self.constwidth);    
						}        
						if(self.options.tint){
							self.tintContainer.css("height", self.options.constrainSize);
							self.tintContainer.css("width", self.constwidth);
							self.zoomTint.css("height", self.options.constrainSize);
							self.zoomTint.css("width", self.constwidth);
							self.zoomTintImage.css("height", self.options.constrainSize);
							self.zoomTintImage.css("width", self.constwidth); 
						} 

					}
					if(self.options.constrainType == "width"){       
						self.zoomContainer.css("height", "auto");
						self.zoomContainer.css("width", self.options.constrainSize);

						if(self.options.imageCrossfade){
							self.zoomWrap.css("height", "auto");
							self.zoomWrap.css("width", self.options.constrainSize);
							self.constheight = self.zoomWrap.height();
						}
						else{            
							self.$elem.css("height", "auto");
							self.$elem.css("width", self.options.constrainSize); 
							self.constheight = self.$elem.height();              
						} 
						if(self.options.zoomType == "inner"){
							self.zoomWrap.parent().css("height", self.constheight);
							self.zoomWrap.parent().css("width", self.options.constrainSize);   
							self.zoomWindow.css("height", self.constheight);
							self.zoomWindow.css("width", self.options.constrainSize);    
						} 
						if(self.options.tint){
							self.tintContainer.css("height", self.constheight);
							self.tintContainer.css("width", self.options.constrainSize);
							self.zoomTint.css("height", self.constheight);
							self.zoomTint.css("width", self.options.constrainSize);
							self.zoomTintImage.css("height", self.constheight);
							self.zoomTintImage.css("width", self.options.constrainSize); 
						}   

					}        


				}

			},
			doneCallback: function(){

				var self = this;
				if(self.options.loadingIcon){
					self.spinner.hide();     
				}   

				self.nzOffset = self.$elem.offset();
				self.nzWidth = self.$elem.width();
				self.nzHeight = self.$elem.height();

				// reset the zoomlevel back to default
				self.currentZoomLevel = self.options.zoomLevel;

				//ratio of the large to small image
				self.widthRatio = self.largeWidth / self.nzWidth;
				self.heightRatio = self.largeHeight / self.nzHeight; 

				//NEED TO ADD THE LENS SIZE FOR ROUND
				// adjust images less than the window height
				if(self.options.zoomType == "window") {

					if(self.nzHeight < self.options.zoomWindowWidth/self.widthRatio){
						lensHeight = self.nzHeight;  

					}
					else{
						lensHeight = String((self.options.zoomWindowHeight/self.heightRatio))
					}

					if(self.options.zoomWindowWidth < self.options.zoomWindowWidth){
						lensWidth = self.nzWidth;
					}       
					else{
						lensWidth =  (self.options.zoomWindowWidth/self.widthRatio);
					}


					if(self.zoomLens){

						self.zoomLens.css('width', lensWidth);    
						self.zoomLens.css('height', lensHeight); 


					}
				}
			},
			getCurrentImage: function(){
				var self = this;  
				return self.zoomImage; 
			}, 
			getGalleryList: function(){
				var self = this;   
				//loop through the gallery options and set them in list for fancybox
				self.gallerylist = [];
				if (self.options.gallery){ 


					$('#'+self.options.gallery + ' a').each(function() {

						var img_src = '';
						if($(this).data("zoom-image")){
							img_src = $(this).data("zoom-image");
						}
						else if($(this).data("image")){
							img_src = $(this).data("image");
						}			
						//put the current image at the start
						if(img_src == self.zoomImage){
							self.gallerylist.unshift({
								href: ''+img_src+'',
								title: $(this).find('img').attr("title")
							});	
						}
						else{
							self.gallerylist.push({
								href: ''+img_src+'',
								title: $(this).find('img').attr("title")
							});
						}


					});
				}                                                       
				//if no gallery - return current image
				else{
					self.gallerylist.push({
						href: ''+self.zoomImage+'',
						title: $(this).find('img').attr("title")
					}); 
				}
				return self.gallerylist;

			},
			changeZoomLevel: function(value){
				var self = this;   

				//flag a zoom, so can adjust the easing during setPosition     
				self.scrollingLock = true;   

				//round to two decimal places
				self.newvalue = parseFloat(value).toFixed(2);
				newvalue = parseFloat(value).toFixed(2);




				//maxwidth & Maxheight of the image
				maxheightnewvalue = self.largeHeight/((self.options.zoomWindowHeight / self.nzHeight) * self.nzHeight);     
				maxwidthtnewvalue = self.largeWidth/((self.options.zoomWindowWidth / self.nzWidth) * self.nzWidth);   	




				//calculate new heightratio
				if(self.options.zoomType != "inner")
				{
					if(maxheightnewvalue <= newvalue){
						self.heightRatio = (self.largeHeight/maxheightnewvalue) / self.nzHeight;
						self.newvalueheight = maxheightnewvalue;
						self.fullheight = true;

					}
					else{
						self.heightRatio = (self.largeHeight/newvalue) / self.nzHeight; 
						self.newvalueheight = newvalue;
						self.fullheight = false;

					}


//					calculate new width ratio

					if(maxwidthtnewvalue <= newvalue){
						self.widthRatio = (self.largeWidth/maxwidthtnewvalue) / self.nzWidth;
						self.newvaluewidth = maxwidthtnewvalue;
						self.fullwidth = true;

					}
					else{
						self.widthRatio = (self.largeWidth/newvalue) / self.nzWidth; 
						self.newvaluewidth = newvalue;
						self.fullwidth = false;

					}
					if(self.options.zoomType == "lens"){
						if(maxheightnewvalue <= newvalue){
							self.fullwidth = true;
							self.newvaluewidth = maxheightnewvalue;

						} else{
							self.widthRatio = (self.largeWidth/newvalue) / self.nzWidth; 
							self.newvaluewidth = newvalue;

							self.fullwidth = false;
						}}
				}



				if(self.options.zoomType == "inner")
				{
					maxheightnewvalue = parseFloat(self.largeHeight/self.nzHeight).toFixed(2);     
					maxwidthtnewvalue = parseFloat(self.largeWidth/self.nzWidth).toFixed(2);      
					if(newvalue > maxheightnewvalue){
						newvalue = maxheightnewvalue;
					}
					if(newvalue > maxwidthtnewvalue){
						newvalue = maxwidthtnewvalue;
					}      


					if(maxheightnewvalue <= newvalue){


						self.heightRatio = (self.largeHeight/newvalue) / self.nzHeight; 
						if(newvalue > maxheightnewvalue){
							self.newvalueheight = maxheightnewvalue;
						}else{
							self.newvalueheight = newvalue;
						}
						self.fullheight = true;


					}
					else{



						self.heightRatio = (self.largeHeight/newvalue) / self.nzHeight; 

						if(newvalue > maxheightnewvalue){

							self.newvalueheight = maxheightnewvalue;
						}else{
							self.newvalueheight = newvalue;
						}
						self.fullheight = false;
					}




					if(maxwidthtnewvalue <= newvalue){   

						self.widthRatio = (self.largeWidth/newvalue) / self.nzWidth; 
						if(newvalue > maxwidthtnewvalue){

							self.newvaluewidth = maxwidthtnewvalue;
						}else{
							self.newvaluewidth = newvalue;
						}

						self.fullwidth = true;


					}
					else{  

						self.widthRatio = (self.largeWidth/newvalue) / self.nzWidth; 
						self.newvaluewidth = newvalue;
						self.fullwidth = false;
					}        


				} //end inner
				scrcontinue = false;

				if(self.options.zoomType == "inner"){

					if(self.nzWidth >= self.nzHeight){
						if( self.newvaluewidth <= maxwidthtnewvalue){
							scrcontinue = true;
						}
						else{

							scrcontinue = false;
							self.fullheight = true;
							self.fullwidth = true;
						}
					}
					if(self.nzHeight > self.nzWidth){     
						if( self.newvaluewidth <= maxwidthtnewvalue){
							scrcontinue = true;
						}
						else{
							scrcontinue = false;  

							self.fullheight = true;
							self.fullwidth = true;
						}
					}
				}

				if(self.options.zoomType != "inner"){
					scrcontinue = true;
				}

				if(scrcontinue){



					self.zoomLock = 0;
					self.changeZoom = true;

					//if lens height is less than image height


					if(((self.options.zoomWindowHeight)/self.heightRatio) <= self.nzHeight){


						self.currentZoomLevel = self.newvalueheight; 
						if(self.options.zoomType != "lens" && self.options.zoomType != "inner") {
							self.changeBgSize = true;

							self.zoomLens.css({height: String((self.options.zoomWindowHeight)/self.heightRatio) + 'px' }) 
						}
						if(self.options.zoomType == "lens" || self.options.zoomType == "inner") {  
							self.changeBgSize = true;  
						}	


					} 




					if((self.options.zoomWindowWidth/self.widthRatio) <= self.nzWidth){



						if(self.options.zoomType != "inner"){
							if(self.newvaluewidth > self.newvalueheight)   {
								self.currentZoomLevel = self.newvaluewidth;                 

							}
						}

						if(self.options.zoomType != "lens" && self.options.zoomType != "inner") {
							self.changeBgSize = true;

							self.zoomLens.css({width: String((self.options.zoomWindowWidth)/self.widthRatio) + 'px' })
						}
						if(self.options.zoomType == "lens" || self.options.zoomType == "inner") {  
							self.changeBgSize = true;
						}	

					}
					if(self.options.zoomType == "inner"){
						self.changeBgSize = true;  

						if(self.nzWidth > self.nzHeight){
							self.currentZoomLevel = self.newvaluewidth;
						}
						if(self.nzHeight > self.nzWidth){
							self.currentZoomLevel = self.newvaluewidth;
						}
					}

				}      //under

				//sets the boundry change, called in setWindowPos
				self.setPosition(self.currentLoc);
				//
			},
			closeAll: function(){
				if(self.zoomWindow){self.zoomWindow.hide();}
				if(self.zoomLens){self.zoomLens.hide();}
				if(self.zoomTint){self.zoomTint.hide();}
			},
			changeState: function(value){
      	var self = this;
				if(value == 'enable'){self.options.zoomEnabled = true;}
				if(value == 'disable'){self.options.zoomEnabled = false;}

			}

	};




	$.fn.elevateZoom = function( options ) {
		return this.each(function() {
			var elevate = Object.create( ElevateZoom );

			elevate.init( options, this );

			$.data( this, 'elevateZoom', elevate );

		});
	};

	$.fn.elevateZoom.options = {
			zoomActivation: "hover", // Can also be click (PLACEHOLDER FOR NEXT VERSION)
      zoomEnabled: true, //false disables zoomwindow from showing
			preloading: 1, //by default, load all the images, if 0, then only load images after activated (PLACEHOLDER FOR NEXT VERSION)
			zoomLevel: 1, //default zoom level of image
			scrollZoom: false, //allow zoom on mousewheel, true to activate
			scrollZoomIncrement: 0.1,  //steps of the scrollzoom
			minZoomLevel: false,
			maxZoomLevel: false,
			easing: false,
			easingAmount: 12,
			lensSize: 200,
			zoomWindowWidth: 400,
			zoomWindowHeight: 400,
			zoomWindowOffetx: 0,
			zoomWindowOffety: 0,
			zoomWindowPosition: 1,
			zoomWindowBgColour: "#fff",
			lensFadeIn: false,
			lensFadeOut: false,
			debug: false,
			zoomWindowFadeIn: false,
			zoomWindowFadeOut: false,
			zoomWindowAlwaysShow: false,
			zoomTintFadeIn: false,
			zoomTintFadeOut: false,
			borderSize: 4,
			showLens: true,
			borderColour: "#888",
			lensBorderSize: 1,
			lensBorderColour: "#000",
			lensShape: "square", //can be "round"
			zoomType: "window", //window is default,  also "lens" available -
			containLensZoom: false,
			lensColour: "white", //colour of the lens background
			lensOpacity: 0.4, //opacity of the lens
			lenszoom: false,
			tint: false, //enable the tinting
			tintColour: "#333", //default tint color, can be anything, red, #ccc, rgb(0,0,0)
			tintOpacity: 0.4, //opacity of the tint
			gallery: false,
			galleryActiveClass: "zoomGalleryActive",
			imageCrossfade: false,
			constrainType: false,  //width or height
			constrainSize: false,  //in pixels the dimensions you want to constrain on
			loadingIcon: false, //http://www.example.com/spinner.gif
			cursor:"default", // user should set to what they want the cursor as, if they have set a click function
			responsive:true,
			onComplete: $.noop,
      onDestroy: function() {},
			onZoomedImageLoaded: function() {},
			onImageSwap: $.noop,
			onImageSwapComplete: $.noop
	};

})( jQuery, window, document );
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
/*! Magnific Popup - v1.1.0 - 2016-02-20
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2016 Dmitry Semenov; */
!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a("object"==typeof exports?require("jquery"):window.jQuery||window.Zepto)}(function(a){var b,c,d,e,f,g,h="Close",i="BeforeClose",j="AfterClose",k="BeforeAppend",l="MarkupParse",m="Open",n="Change",o="mfp",p="."+o,q="mfp-ready",r="mfp-removing",s="mfp-prevent-close",t=function(){},u=!!window.jQuery,v=a(window),w=function(a,c){b.ev.on(o+a+p,c)},x=function(b,c,d,e){var f=document.createElement("div");return f.className="mfp-"+b,d&&(f.innerHTML=d),e?c&&c.appendChild(f):(f=a(f),c&&f.appendTo(c)),f},y=function(c,d){b.ev.triggerHandler(o+c,d),b.st.callbacks&&(c=c.charAt(0).toLowerCase()+c.slice(1),b.st.callbacks[c]&&b.st.callbacks[c].apply(b,a.isArray(d)?d:[d]))},z=function(c){return c===g&&b.currTemplate.closeBtn||(b.currTemplate.closeBtn=a(b.st.closeMarkup.replace("%title%",b.st.tClose)),g=c),b.currTemplate.closeBtn},A=function(){a.magnificPopup.instance||(b=new t,b.init(),a.magnificPopup.instance=b)},B=function(){var a=document.createElement("p").style,b=["ms","O","Moz","Webkit"];if(void 0!==a.transition)return!0;for(;b.length;)if(b.pop()+"Transition"in a)return!0;return!1};t.prototype={constructor:t,init:function(){var c=navigator.appVersion;b.isLowIE=b.isIE8=document.all&&!document.addEventListener,b.isAndroid=/android/gi.test(c),b.isIOS=/iphone|ipad|ipod/gi.test(c),b.supportsTransition=B(),b.probablyMobile=b.isAndroid||b.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),d=a(document),b.popupsCache={}},open:function(c){var e;if(c.isObj===!1){b.items=c.items.toArray(),b.index=0;var g,h=c.items;for(e=0;e<h.length;e++)if(g=h[e],g.parsed&&(g=g.el[0]),g===c.el[0]){b.index=e;break}}else b.items=a.isArray(c.items)?c.items:[c.items],b.index=c.index||0;if(b.isOpen)return void b.updateItemHTML();b.types=[],f="",c.mainEl&&c.mainEl.length?b.ev=c.mainEl.eq(0):b.ev=d,c.key?(b.popupsCache[c.key]||(b.popupsCache[c.key]={}),b.currTemplate=b.popupsCache[c.key]):b.currTemplate={},b.st=a.extend(!0,{},a.magnificPopup.defaults,c),b.fixedContentPos="auto"===b.st.fixedContentPos?!b.probablyMobile:b.st.fixedContentPos,b.st.modal&&(b.st.closeOnContentClick=!1,b.st.closeOnBgClick=!1,b.st.showCloseBtn=!1,b.st.enableEscapeKey=!1),b.bgOverlay||(b.bgOverlay=x("bg").on("click"+p,function(){b.close()}),b.wrap=x("wrap").attr("tabindex",-1).on("click"+p,function(a){b._checkIfClose(a.target)&&b.close()}),b.container=x("container",b.wrap)),b.contentContainer=x("content"),b.st.preloader&&(b.preloader=x("preloader",b.container,b.st.tLoading));var i=a.magnificPopup.modules;for(e=0;e<i.length;e++){var j=i[e];j=j.charAt(0).toUpperCase()+j.slice(1),b["init"+j].call(b)}y("BeforeOpen"),b.st.showCloseBtn&&(b.st.closeBtnInside?(w(l,function(a,b,c,d){c.close_replaceWith=z(d.type)}),f+=" mfp-close-btn-in"):b.wrap.append(z())),b.st.alignTop&&(f+=" mfp-align-top"),b.fixedContentPos?b.wrap.css({overflow:b.st.overflowY,overflowX:"hidden",overflowY:b.st.overflowY}):b.wrap.css({top:v.scrollTop(),position:"absolute"}),(b.st.fixedBgPos===!1||"auto"===b.st.fixedBgPos&&!b.fixedContentPos)&&b.bgOverlay.css({height:d.height(),position:"absolute"}),b.st.enableEscapeKey&&d.on("keyup"+p,function(a){27===a.keyCode&&b.close()}),v.on("resize"+p,function(){b.updateSize()}),b.st.closeOnContentClick||(f+=" mfp-auto-cursor"),f&&b.wrap.addClass(f);var k=b.wH=v.height(),n={};if(b.fixedContentPos&&b._hasScrollBar(k)){var o=b._getScrollbarSize();o&&(n.marginRight=o)}b.fixedContentPos&&(b.isIE7?a("body, html").css("overflow","hidden"):n.overflow="hidden");var r=b.st.mainClass;return b.isIE7&&(r+=" mfp-ie7"),r&&b._addClassToMFP(r),b.updateItemHTML(),y("BuildControls"),a("html").css(n),b.bgOverlay.add(b.wrap).prependTo(b.st.prependTo||a(document.body)),b._lastFocusedEl=document.activeElement,setTimeout(function(){b.content?(b._addClassToMFP(q),b._setFocus()):b.bgOverlay.addClass(q),d.on("focusin"+p,b._onFocusIn)},16),b.isOpen=!0,b.updateSize(k),y(m),c},close:function(){b.isOpen&&(y(i),b.isOpen=!1,b.st.removalDelay&&!b.isLowIE&&b.supportsTransition?(b._addClassToMFP(r),setTimeout(function(){b._close()},b.st.removalDelay)):b._close())},_close:function(){y(h);var c=r+" "+q+" ";if(b.bgOverlay.detach(),b.wrap.detach(),b.container.empty(),b.st.mainClass&&(c+=b.st.mainClass+" "),b._removeClassFromMFP(c),b.fixedContentPos){var e={marginRight:""};b.isIE7?a("body, html").css("overflow",""):e.overflow="",a("html").css(e)}d.off("keyup"+p+" focusin"+p),b.ev.off(p),b.wrap.attr("class","mfp-wrap").removeAttr("style"),b.bgOverlay.attr("class","mfp-bg"),b.container.attr("class","mfp-container"),!b.st.showCloseBtn||b.st.closeBtnInside&&b.currTemplate[b.currItem.type]!==!0||b.currTemplate.closeBtn&&b.currTemplate.closeBtn.detach(),b.st.autoFocusLast&&b._lastFocusedEl&&a(b._lastFocusedEl).focus(),b.currItem=null,b.content=null,b.currTemplate=null,b.prevHeight=0,y(j)},updateSize:function(a){if(b.isIOS){var c=document.documentElement.clientWidth/window.innerWidth,d=window.innerHeight*c;b.wrap.css("height",d),b.wH=d}else b.wH=a||v.height();b.fixedContentPos||b.wrap.css("height",b.wH),y("Resize")},updateItemHTML:function(){var c=b.items[b.index];b.contentContainer.detach(),b.content&&b.content.detach(),c.parsed||(c=b.parseEl(b.index));var d=c.type;if(y("BeforeChange",[b.currItem?b.currItem.type:"",d]),b.currItem=c,!b.currTemplate[d]){var f=b.st[d]?b.st[d].markup:!1;y("FirstMarkupParse",f),f?b.currTemplate[d]=a(f):b.currTemplate[d]=!0}e&&e!==c.type&&b.container.removeClass("mfp-"+e+"-holder");var g=b["get"+d.charAt(0).toUpperCase()+d.slice(1)](c,b.currTemplate[d]);b.appendContent(g,d),c.preloaded=!0,y(n,c),e=c.type,b.container.prepend(b.contentContainer),y("AfterChange")},appendContent:function(a,c){b.content=a,a?b.st.showCloseBtn&&b.st.closeBtnInside&&b.currTemplate[c]===!0?b.content.find(".mfp-close").length||b.content.append(z()):b.content=a:b.content="",y(k),b.container.addClass("mfp-"+c+"-holder"),b.contentContainer.append(b.content)},parseEl:function(c){var d,e=b.items[c];if(e.tagName?e={el:a(e)}:(d=e.type,e={data:e,src:e.src}),e.el){for(var f=b.types,g=0;g<f.length;g++)if(e.el.hasClass("mfp-"+f[g])){d=f[g];break}e.src=e.el.attr("data-mfp-src"),e.src||(e.src=e.el.attr("href"))}return e.type=d||b.st.type||"inline",e.index=c,e.parsed=!0,b.items[c]=e,y("ElementParse",e),b.items[c]},addGroup:function(a,c){var d=function(d){d.mfpEl=this,b._openClick(d,a,c)};c||(c={});var e="click.magnificPopup";c.mainEl=a,c.items?(c.isObj=!0,a.off(e).on(e,d)):(c.isObj=!1,c.delegate?a.off(e).on(e,c.delegate,d):(c.items=a,a.off(e).on(e,d)))},_openClick:function(c,d,e){var f=void 0!==e.midClick?e.midClick:a.magnificPopup.defaults.midClick;if(f||!(2===c.which||c.ctrlKey||c.metaKey||c.altKey||c.shiftKey)){var g=void 0!==e.disableOn?e.disableOn:a.magnificPopup.defaults.disableOn;if(g)if(a.isFunction(g)){if(!g.call(b))return!0}else if(v.width()<g)return!0;c.type&&(c.preventDefault(),b.isOpen&&c.stopPropagation()),e.el=a(c.mfpEl),e.delegate&&(e.items=d.find(e.delegate)),b.open(e)}},updateStatus:function(a,d){if(b.preloader){c!==a&&b.container.removeClass("mfp-s-"+c),d||"loading"!==a||(d=b.st.tLoading);var e={status:a,text:d};y("UpdateStatus",e),a=e.status,d=e.text,b.preloader.html(d),b.preloader.find("a").on("click",function(a){a.stopImmediatePropagation()}),b.container.addClass("mfp-s-"+a),c=a}},_checkIfClose:function(c){if(!a(c).hasClass(s)){var d=b.st.closeOnContentClick,e=b.st.closeOnBgClick;if(d&&e)return!0;if(!b.content||a(c).hasClass("mfp-close")||b.preloader&&c===b.preloader[0])return!0;if(c===b.content[0]||a.contains(b.content[0],c)){if(d)return!0}else if(e&&a.contains(document,c))return!0;return!1}},_addClassToMFP:function(a){b.bgOverlay.addClass(a),b.wrap.addClass(a)},_removeClassFromMFP:function(a){this.bgOverlay.removeClass(a),b.wrap.removeClass(a)},_hasScrollBar:function(a){return(b.isIE7?d.height():document.body.scrollHeight)>(a||v.height())},_setFocus:function(){(b.st.focus?b.content.find(b.st.focus).eq(0):b.wrap).focus()},_onFocusIn:function(c){return c.target===b.wrap[0]||a.contains(b.wrap[0],c.target)?void 0:(b._setFocus(),!1)},_parseMarkup:function(b,c,d){var e;d.data&&(c=a.extend(d.data,c)),y(l,[b,c,d]),a.each(c,function(c,d){if(void 0===d||d===!1)return!0;if(e=c.split("_"),e.length>1){var f=b.find(p+"-"+e[0]);if(f.length>0){var g=e[1];"replaceWith"===g?f[0]!==d[0]&&f.replaceWith(d):"img"===g?f.is("img")?f.attr("src",d):f.replaceWith(a("<img>").attr("src",d).attr("class",f.attr("class"))):f.attr(e[1],d)}}else b.find(p+"-"+c).html(d)})},_getScrollbarSize:function(){if(void 0===b.scrollbarSize){var a=document.createElement("div");a.style.cssText="width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;",document.body.appendChild(a),b.scrollbarSize=a.offsetWidth-a.clientWidth,document.body.removeChild(a)}return b.scrollbarSize}},a.magnificPopup={instance:null,proto:t.prototype,modules:[],open:function(b,c){return A(),b=b?a.extend(!0,{},b):{},b.isObj=!0,b.index=c||0,this.instance.open(b)},close:function(){return a.magnificPopup.instance&&a.magnificPopup.instance.close()},registerModule:function(b,c){c.options&&(a.magnificPopup.defaults[b]=c.options),a.extend(this.proto,c.proto),this.modules.push(b)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:"",preloader:!0,focus:"",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:"auto",fixedBgPos:"auto",overflowY:"auto",closeMarkup:'<button title="%title%" type="button" class="mfp-close">&#215;</button>',tClose:"Close (Esc)",tLoading:"Loading...",autoFocusLast:!0}},a.fn.magnificPopup=function(c){A();var d=a(this);if("string"==typeof c)if("open"===c){var e,f=u?d.data("magnificPopup"):d[0].magnificPopup,g=parseInt(arguments[1],10)||0;f.items?e=f.items[g]:(e=d,f.delegate&&(e=e.find(f.delegate)),e=e.eq(g)),b._openClick({mfpEl:e},d,f)}else b.isOpen&&b[c].apply(b,Array.prototype.slice.call(arguments,1));else c=a.extend(!0,{},c),u?d.data("magnificPopup",c):d[0].magnificPopup=c,b.addGroup(d,c);return d};var C,D,E,F="inline",G=function(){E&&(D.after(E.addClass(C)).detach(),E=null)};a.magnificPopup.registerModule(F,{options:{hiddenClass:"hide",markup:"",tNotFound:"Content not found"},proto:{initInline:function(){b.types.push(F),w(h+"."+F,function(){G()})},getInline:function(c,d){if(G(),c.src){var e=b.st.inline,f=a(c.src);if(f.length){var g=f[0].parentNode;g&&g.tagName&&(D||(C=e.hiddenClass,D=x(C),C="mfp-"+C),E=f.after(D).detach().removeClass(C)),b.updateStatus("ready")}else b.updateStatus("error",e.tNotFound),f=a("<div>");return c.inlineElement=f,f}return b.updateStatus("ready"),b._parseMarkup(d,{},c),d}}});var H,I="ajax",J=function(){H&&a(document.body).removeClass(H)},K=function(){J(),b.req&&b.req.abort()};a.magnificPopup.registerModule(I,{options:{settings:null,cursor:"mfp-ajax-cur",tError:'<a href="%url%">The content</a> could not be loaded.'},proto:{initAjax:function(){b.types.push(I),H=b.st.ajax.cursor,w(h+"."+I,K),w("BeforeChange."+I,K)},getAjax:function(c){H&&a(document.body).addClass(H),b.updateStatus("loading");var d=a.extend({url:c.src,success:function(d,e,f){var g={data:d,xhr:f};y("ParseAjax",g),b.appendContent(a(g.data),I),c.finished=!0,J(),b._setFocus(),setTimeout(function(){b.wrap.addClass(q)},16),b.updateStatus("ready"),y("AjaxContentAdded")},error:function(){J(),c.finished=c.loadError=!0,b.updateStatus("error",b.st.ajax.tError.replace("%url%",c.src))}},b.st.ajax.settings);return b.req=a.ajax(d),""}}});var L,M=function(c){if(c.data&&void 0!==c.data.title)return c.data.title;var d=b.st.image.titleSrc;if(d){if(a.isFunction(d))return d.call(b,c);if(c.el)return c.el.attr(d)||""}return""};a.magnificPopup.registerModule("image",{options:{markup:'<div class="mfp-figure"><div class="mfp-close"></div><figure><div class="mfp-img"></div><figcaption><div class="mfp-bottom-bar"><div class="mfp-title"></div><div class="mfp-counter"></div></div></figcaption></figure></div>',cursor:"mfp-zoom-out-cur",titleSrc:"title",verticalFit:!0,tError:'<a href="%url%">The image</a> could not be loaded.'},proto:{initImage:function(){var c=b.st.image,d=".image";b.types.push("image"),w(m+d,function(){"image"===b.currItem.type&&c.cursor&&a(document.body).addClass(c.cursor)}),w(h+d,function(){c.cursor&&a(document.body).removeClass(c.cursor),v.off("resize"+p)}),w("Resize"+d,b.resizeImage),b.isLowIE&&w("AfterChange",b.resizeImage)},resizeImage:function(){var a=b.currItem;if(a&&a.img&&b.st.image.verticalFit){var c=0;b.isLowIE&&(c=parseInt(a.img.css("padding-top"),10)+parseInt(a.img.css("padding-bottom"),10)),a.img.css("max-height",b.wH-c)}},_onImageHasSize:function(a){a.img&&(a.hasSize=!0,L&&clearInterval(L),a.isCheckingImgSize=!1,y("ImageHasSize",a),a.imgHidden&&(b.content&&b.content.removeClass("mfp-loading"),a.imgHidden=!1))},findImageSize:function(a){var c=0,d=a.img[0],e=function(f){L&&clearInterval(L),L=setInterval(function(){return d.naturalWidth>0?void b._onImageHasSize(a):(c>200&&clearInterval(L),c++,void(3===c?e(10):40===c?e(50):100===c&&e(500)))},f)};e(1)},getImage:function(c,d){var e=0,f=function(){c&&(c.img[0].complete?(c.img.off(".mfploader"),c===b.currItem&&(b._onImageHasSize(c),b.updateStatus("ready")),c.hasSize=!0,c.loaded=!0,y("ImageLoadComplete")):(e++,200>e?setTimeout(f,100):g()))},g=function(){c&&(c.img.off(".mfploader"),c===b.currItem&&(b._onImageHasSize(c),b.updateStatus("error",h.tError.replace("%url%",c.src))),c.hasSize=!0,c.loaded=!0,c.loadError=!0)},h=b.st.image,i=d.find(".mfp-img");if(i.length){var j=document.createElement("img");j.className="mfp-img",c.el&&c.el.find("img").length&&(j.alt=c.el.find("img").attr("alt")),c.img=a(j).on("load.mfploader",f).on("error.mfploader",g),j.src=c.src,i.is("img")&&(c.img=c.img.clone()),j=c.img[0],j.naturalWidth>0?c.hasSize=!0:j.width||(c.hasSize=!1)}return b._parseMarkup(d,{title:M(c),img_replaceWith:c.img},c),b.resizeImage(),c.hasSize?(L&&clearInterval(L),c.loadError?(d.addClass("mfp-loading"),b.updateStatus("error",h.tError.replace("%url%",c.src))):(d.removeClass("mfp-loading"),b.updateStatus("ready")),d):(b.updateStatus("loading"),c.loading=!0,c.hasSize||(c.imgHidden=!0,d.addClass("mfp-loading"),b.findImageSize(c)),d)}}});var N,O=function(){return void 0===N&&(N=void 0!==document.createElement("p").style.MozTransform),N};a.magnificPopup.registerModule("zoom",{options:{enabled:!1,easing:"ease-in-out",duration:300,opener:function(a){return a.is("img")?a:a.find("img")}},proto:{initZoom:function(){var a,c=b.st.zoom,d=".zoom";if(c.enabled&&b.supportsTransition){var e,f,g=c.duration,j=function(a){var b=a.clone().removeAttr("style").removeAttr("class").addClass("mfp-animated-image"),d="all "+c.duration/1e3+"s "+c.easing,e={position:"fixed",zIndex:9999,left:0,top:0,"-webkit-backface-visibility":"hidden"},f="transition";return e["-webkit-"+f]=e["-moz-"+f]=e["-o-"+f]=e[f]=d,b.css(e),b},k=function(){b.content.css("visibility","visible")};w("BuildControls"+d,function(){if(b._allowZoom()){if(clearTimeout(e),b.content.css("visibility","hidden"),a=b._getItemToZoom(),!a)return void k();f=j(a),f.css(b._getOffset()),b.wrap.append(f),e=setTimeout(function(){f.css(b._getOffset(!0)),e=setTimeout(function(){k(),setTimeout(function(){f.remove(),a=f=null,y("ZoomAnimationEnded")},16)},g)},16)}}),w(i+d,function(){if(b._allowZoom()){if(clearTimeout(e),b.st.removalDelay=g,!a){if(a=b._getItemToZoom(),!a)return;f=j(a)}f.css(b._getOffset(!0)),b.wrap.append(f),b.content.css("visibility","hidden"),setTimeout(function(){f.css(b._getOffset())},16)}}),w(h+d,function(){b._allowZoom()&&(k(),f&&f.remove(),a=null)})}},_allowZoom:function(){return"image"===b.currItem.type},_getItemToZoom:function(){return b.currItem.hasSize?b.currItem.img:!1},_getOffset:function(c){var d;d=c?b.currItem.img:b.st.zoom.opener(b.currItem.el||b.currItem);var e=d.offset(),f=parseInt(d.css("padding-top"),10),g=parseInt(d.css("padding-bottom"),10);e.top-=a(window).scrollTop()-f;var h={width:d.width(),height:(u?d.innerHeight():d[0].offsetHeight)-g-f};return O()?h["-moz-transform"]=h.transform="translate("+e.left+"px,"+e.top+"px)":(h.left=e.left,h.top=e.top),h}}});var P="iframe",Q="//about:blank",R=function(a){if(b.currTemplate[P]){var c=b.currTemplate[P].find("iframe");c.length&&(a||(c[0].src=Q),b.isIE8&&c.css("display",a?"block":"none"))}};a.magnificPopup.registerModule(P,{options:{markup:'<div class="mfp-iframe-scaler"><div class="mfp-close"></div><iframe class="mfp-iframe" src="//about:blank" frameborder="0" allowfullscreen></iframe></div>',srcAction:"iframe_src",patterns:{youtube:{index:"youtube.com",id:"v=",src:"//www.youtube.com/embed/%id%?autoplay=1"},vimeo:{index:"vimeo.com/",id:"/",src:"//player.vimeo.com/video/%id%?autoplay=1"},gmaps:{index:"//maps.google.",src:"%id%&output=embed"}}},proto:{initIframe:function(){b.types.push(P),w("BeforeChange",function(a,b,c){b!==c&&(b===P?R():c===P&&R(!0))}),w(h+"."+P,function(){R()})},getIframe:function(c,d){var e=c.src,f=b.st.iframe;a.each(f.patterns,function(){return e.indexOf(this.index)>-1?(this.id&&(e="string"==typeof this.id?e.substr(e.lastIndexOf(this.id)+this.id.length,e.length):this.id.call(this,e)),e=this.src.replace("%id%",e),!1):void 0});var g={};return f.srcAction&&(g[f.srcAction]=e),b._parseMarkup(d,g,c),b.updateStatus("ready"),d}}});var S=function(a){var c=b.items.length;return a>c-1?a-c:0>a?c+a:a},T=function(a,b,c){return a.replace(/%curr%/gi,b+1).replace(/%total%/gi,c)};a.magnificPopup.registerModule("gallery",{options:{enabled:!1,arrowMarkup:'<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:"Previous (Left arrow key)",tNext:"Next (Right arrow key)",tCounter:"%curr% of %total%"},proto:{initGallery:function(){var c=b.st.gallery,e=".mfp-gallery";return b.direction=!0,c&&c.enabled?(f+=" mfp-gallery",w(m+e,function(){c.navigateByImgClick&&b.wrap.on("click"+e,".mfp-img",function(){return b.items.length>1?(b.next(),!1):void 0}),d.on("keydown"+e,function(a){37===a.keyCode?b.prev():39===a.keyCode&&b.next()})}),w("UpdateStatus"+e,function(a,c){c.text&&(c.text=T(c.text,b.currItem.index,b.items.length))}),w(l+e,function(a,d,e,f){var g=b.items.length;e.counter=g>1?T(c.tCounter,f.index,g):""}),w("BuildControls"+e,function(){if(b.items.length>1&&c.arrows&&!b.arrowLeft){var d=c.arrowMarkup,e=b.arrowLeft=a(d.replace(/%title%/gi,c.tPrev).replace(/%dir%/gi,"left")).addClass(s),f=b.arrowRight=a(d.replace(/%title%/gi,c.tNext).replace(/%dir%/gi,"right")).addClass(s);e.click(function(){b.prev()}),f.click(function(){b.next()}),b.container.append(e.add(f))}}),w(n+e,function(){b._preloadTimeout&&clearTimeout(b._preloadTimeout),b._preloadTimeout=setTimeout(function(){b.preloadNearbyImages(),b._preloadTimeout=null},16)}),void w(h+e,function(){d.off(e),b.wrap.off("click"+e),b.arrowRight=b.arrowLeft=null})):!1},next:function(){b.direction=!0,b.index=S(b.index+1),b.updateItemHTML()},prev:function(){b.direction=!1,b.index=S(b.index-1),b.updateItemHTML()},goTo:function(a){b.direction=a>=b.index,b.index=a,b.updateItemHTML()},preloadNearbyImages:function(){var a,c=b.st.gallery.preload,d=Math.min(c[0],b.items.length),e=Math.min(c[1],b.items.length);for(a=1;a<=(b.direction?e:d);a++)b._preloadItem(b.index+a);for(a=1;a<=(b.direction?d:e);a++)b._preloadItem(b.index-a)},_preloadItem:function(c){if(c=S(c),!b.items[c].preloaded){var d=b.items[c];d.parsed||(d=b.parseEl(c)),y("LazyLoad",d),"image"===d.type&&(d.img=a('<img class="mfp-img" />').on("load.mfploader",function(){d.hasSize=!0}).on("error.mfploader",function(){d.hasSize=!0,d.loadError=!0,y("LazyLoadError",d)}).attr("src",d.src)),d.preloaded=!0}}}});var U="retina";a.magnificPopup.registerModule(U,{options:{replaceSrc:function(a){return a.src.replace(/\.\w+$/,function(a){return"@2x"+a})},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var a=b.st.retina,c=a.ratio;c=isNaN(c)?c():c,c>1&&(w("ImageHasSize."+U,function(a,b){b.img.css({"max-width":b.img[0].naturalWidth/c,width:"100%"})}),w("ElementParse."+U,function(b,d){d.src=a.replaceSrc(d,c)}))}}}}),A()});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.AOS=t()}(this,function(){"use strict";var e="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{},t="Expected a function",n=NaN,o="[object Symbol]",i=/^\s+|\s+$/g,a=/^[-+]0x[0-9a-f]+$/i,r=/^0b[01]+$/i,c=/^0o[0-7]+$/i,s=parseInt,u="object"==typeof e&&e&&e.Object===Object&&e,d="object"==typeof self&&self&&self.Object===Object&&self,l=u||d||Function("return this")(),f=Object.prototype.toString,m=Math.max,p=Math.min,b=function(){return l.Date.now()};function v(e,n,o){var i,a,r,c,s,u,d=0,l=!1,f=!1,v=!0;if("function"!=typeof e)throw new TypeError(t);function y(t){var n=i,o=a;return i=a=void 0,d=t,c=e.apply(o,n)}function h(e){var t=e-u;return void 0===u||t>=n||t<0||f&&e-d>=r}function k(){var e=b();if(h(e))return x(e);s=setTimeout(k,function(e){var t=n-(e-u);return f?p(t,r-(e-d)):t}(e))}function x(e){return s=void 0,v&&i?y(e):(i=a=void 0,c)}function O(){var e=b(),t=h(e);if(i=arguments,a=this,u=e,t){if(void 0===s)return function(e){return d=e,s=setTimeout(k,n),l?y(e):c}(u);if(f)return s=setTimeout(k,n),y(u)}return void 0===s&&(s=setTimeout(k,n)),c}return n=w(n)||0,g(o)&&(l=!!o.leading,r=(f="maxWait"in o)?m(w(o.maxWait)||0,n):r,v="trailing"in o?!!o.trailing:v),O.cancel=function(){void 0!==s&&clearTimeout(s),d=0,i=u=a=s=void 0},O.flush=function(){return void 0===s?c:x(b())},O}function g(e){var t=typeof e;return!!e&&("object"==t||"function"==t)}function w(e){if("number"==typeof e)return e;if(function(e){return"symbol"==typeof e||function(e){return!!e&&"object"==typeof e}(e)&&f.call(e)==o}(e))return n;if(g(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=g(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=e.replace(i,"");var u=r.test(e);return u||c.test(e)?s(e.slice(2),u?2:8):a.test(e)?n:+e}var y=function(e,n,o){var i=!0,a=!0;if("function"!=typeof e)throw new TypeError(t);return g(o)&&(i="leading"in o?!!o.leading:i,a="trailing"in o?!!o.trailing:a),v(e,n,{leading:i,maxWait:n,trailing:a})},h="Expected a function",k=NaN,x="[object Symbol]",O=/^\s+|\s+$/g,j=/^[-+]0x[0-9a-f]+$/i,E=/^0b[01]+$/i,N=/^0o[0-7]+$/i,z=parseInt,C="object"==typeof e&&e&&e.Object===Object&&e,A="object"==typeof self&&self&&self.Object===Object&&self,q=C||A||Function("return this")(),L=Object.prototype.toString,T=Math.max,M=Math.min,S=function(){return q.Date.now()};function D(e){var t=typeof e;return!!e&&("object"==t||"function"==t)}function H(e){if("number"==typeof e)return e;if(function(e){return"symbol"==typeof e||function(e){return!!e&&"object"==typeof e}(e)&&L.call(e)==x}(e))return k;if(D(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=D(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=e.replace(O,"");var n=E.test(e);return n||N.test(e)?z(e.slice(2),n?2:8):j.test(e)?k:+e}var $=function(e,t,n){var o,i,a,r,c,s,u=0,d=!1,l=!1,f=!0;if("function"!=typeof e)throw new TypeError(h);function m(t){var n=o,a=i;return o=i=void 0,u=t,r=e.apply(a,n)}function p(e){var n=e-s;return void 0===s||n>=t||n<0||l&&e-u>=a}function b(){var e=S();if(p(e))return v(e);c=setTimeout(b,function(e){var n=t-(e-s);return l?M(n,a-(e-u)):n}(e))}function v(e){return c=void 0,f&&o?m(e):(o=i=void 0,r)}function g(){var e=S(),n=p(e);if(o=arguments,i=this,s=e,n){if(void 0===c)return function(e){return u=e,c=setTimeout(b,t),d?m(e):r}(s);if(l)return c=setTimeout(b,t),m(s)}return void 0===c&&(c=setTimeout(b,t)),r}return t=H(t)||0,D(n)&&(d=!!n.leading,a=(l="maxWait"in n)?T(H(n.maxWait)||0,t):a,f="trailing"in n?!!n.trailing:f),g.cancel=function(){void 0!==c&&clearTimeout(c),u=0,o=s=i=c=void 0},g.flush=function(){return void 0===c?r:v(S())},g},W=function(){};function P(e){e&&e.forEach(function(e){var t=Array.prototype.slice.call(e.addedNodes),n=Array.prototype.slice.call(e.removedNodes);if(function e(t){var n=void 0,o=void 0;for(n=0;n<t.length;n+=1){if((o=t[n]).dataset&&o.dataset.aos)return!0;if(o.children&&e(o.children))return!0}return!1}(t.concat(n)))return W()})}function Y(){return window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver}var _={isSupported:function(){return!!Y()},ready:function(e,t){var n=window.document,o=new(Y())(P);W=t,o.observe(n.documentElement,{childList:!0,subtree:!0,removedNodes:!0})}},B=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},F=function(){function e(e,t){for(var n=0;n<t.length;n++){var o=t[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(t,n,o){return n&&e(t.prototype,n),o&&e(t,o),t}}(),I=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(e[o]=n[o])}return e},K=/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i,G=/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i,J=/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i,Q=/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i;function R(){return navigator.userAgent||navigator.vendor||window.opera||""}var U=new(function(){function e(){B(this,e)}return F(e,[{key:"phone",value:function(){var e=R();return!(!K.test(e)&&!G.test(e.substr(0,4)))}},{key:"mobile",value:function(){var e=R();return!(!J.test(e)&&!Q.test(e.substr(0,4)))}},{key:"tablet",value:function(){return this.mobile()&&!this.phone()}},{key:"ie11",value:function(){return"-ms-scroll-limit"in document.documentElement.style&&"-ms-ime-align"in document.documentElement.style}}]),e}()),V=function(e,t){var n=void 0;return U.ie11()?(n=document.createEvent("CustomEvent")).initCustomEvent(e,!0,!0,{detail:t}):n=new CustomEvent(e,{detail:t}),document.dispatchEvent(n)},X=function(e){return e.forEach(function(e,t){return function(e,t){var n=e.options,o=e.position,i=e.node,a=(e.data,function(){e.animated&&(function(e,t){t&&t.forEach(function(t){return e.classList.remove(t)})}(i,n.animatedClassNames),V("aos:out",i),e.options.id&&V("aos:in:"+e.options.id,i),e.animated=!1)});n.mirror&&t>=o.out&&!n.once?a():t>=o.in?e.animated||(function(e,t){t&&t.forEach(function(t){return e.classList.add(t)})}(i,n.animatedClassNames),V("aos:in",i),e.options.id&&V("aos:in:"+e.options.id,i),e.animated=!0):e.animated&&!n.once&&a()}(e,window.pageYOffset)})},Z=function(e){for(var t=0,n=0;e&&!isNaN(e.offsetLeft)&&!isNaN(e.offsetTop);)t+=e.offsetLeft-("BODY"!=e.tagName?e.scrollLeft:0),n+=e.offsetTop-("BODY"!=e.tagName?e.scrollTop:0),e=e.offsetParent;return{top:n,left:t}},ee=function(e,t,n){var o=e.getAttribute("data-aos-"+t);if(void 0!==o){if("true"===o)return!0;if("false"===o)return!1}return o||n},te=function(e,t){return e.forEach(function(e,n){var o=ee(e.node,"mirror",t.mirror),i=ee(e.node,"once",t.once),a=ee(e.node,"id"),r=t.useClassNames&&e.node.getAttribute("data-aos"),c=[t.animatedClassName].concat(r?r.split(" "):[]).filter(function(e){return"string"==typeof e});t.initClassName&&e.node.classList.add(t.initClassName),e.position={in:function(e,t,n){var o=window.innerHeight,i=ee(e,"anchor"),a=ee(e,"anchor-placement"),r=Number(ee(e,"offset",a?0:t)),c=a||n,s=e;i&&document.querySelectorAll(i)&&(s=document.querySelectorAll(i)[0]);var u=Z(s).top-o;switch(c){case"top-bottom":break;case"center-bottom":u+=s.offsetHeight/2;break;case"bottom-bottom":u+=s.offsetHeight;break;case"top-center":u+=o/2;break;case"center-center":u+=o/2+s.offsetHeight/2;break;case"bottom-center":u+=o/2+s.offsetHeight;break;case"top-top":u+=o;break;case"bottom-top":u+=o+s.offsetHeight;break;case"center-top":u+=o+s.offsetHeight/2}return u+r}(e.node,t.offset,t.anchorPlacement),out:o&&function(e,t){window.innerHeight;var n=ee(e,"anchor"),o=ee(e,"offset",t),i=e;return n&&document.querySelectorAll(n)&&(i=document.querySelectorAll(n)[0]),Z(i).top+i.offsetHeight-o}(e.node,t.offset)},e.options={once:i,mirror:o,animatedClassNames:c,id:a}}),e},ne=function(){var e=document.querySelectorAll("[data-aos]");return Array.prototype.map.call(e,function(e){return{node:e}})},oe=[],ie=!1,ae={offset:120,delay:0,easing:"ease",duration:400,disable:!1,once:!1,mirror:!1,anchorPlacement:"top-bottom",startEvent:"DOMContentLoaded",animatedClassName:"aos-animate",initClassName:"aos-init",useClassNames:!1,disableMutationObserver:!1,throttleDelay:99,debounceDelay:50},re=function(){return document.all&&!window.atob},ce=function(){arguments.length>0&&void 0!==arguments[0]&&arguments[0]&&(ie=!0),ie&&(oe=te(oe,ae),X(oe),window.addEventListener("scroll",y(function(){X(oe,ae.once)},ae.throttleDelay)))},se=function(){if(oe=ne(),de(ae.disable)||re())return ue();ce()},ue=function(){oe.forEach(function(e,t){e.node.removeAttribute("data-aos"),e.node.removeAttribute("data-aos-easing"),e.node.removeAttribute("data-aos-duration"),e.node.removeAttribute("data-aos-delay"),ae.initClassName&&e.node.classList.remove(ae.initClassName),ae.animatedClassName&&e.node.classList.remove(ae.animatedClassName)})},de=function(e){return!0===e||"mobile"===e&&U.mobile()||"phone"===e&&U.phone()||"tablet"===e&&U.tablet()||"function"==typeof e&&!0===e()};return{init:function(e){return ae=I(ae,e),oe=ne(),ae.disableMutationObserver||_.isSupported()||(console.info('\n      aos: MutationObserver is not supported on this browser,\n      code mutations observing has been disabled.\n      You may have to call "refreshHard()" by yourself.\n    '),ae.disableMutationObserver=!0),ae.disableMutationObserver||_.ready("[data-aos]",se),de(ae.disable)||re()?ue():(document.querySelector("body").setAttribute("data-aos-easing",ae.easing),document.querySelector("body").setAttribute("data-aos-duration",ae.duration),document.querySelector("body").setAttribute("data-aos-delay",ae.delay),-1===["DOMContentLoaded","load"].indexOf(ae.startEvent)?document.addEventListener(ae.startEvent,function(){ce(!0)}):window.addEventListener("load",function(){ce(!0)}),"DOMContentLoaded"===ae.startEvent&&["complete","interactive"].indexOf(document.readyState)>-1&&ce(!0),window.addEventListener("resize",$(ce,ae.debounceDelay,!0)),window.addEventListener("orientationchange",$(ce,ae.debounceDelay,!0)),oe)},refresh:ce,refreshHard:se}});

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
/*
 2017 Julian Garnier
 Released under the MIT license
*/
var $jscomp={scope:{}};$jscomp.defineProperty="function"==typeof Object.defineProperties?Object.defineProperty:function(e,r,p){if(p.get||p.set)throw new TypeError("ES3 does not support getters and setters.");e!=Array.prototype&&e!=Object.prototype&&(e[r]=p.value)};$jscomp.getGlobal=function(e){return"undefined"!=typeof window&&window===e?e:"undefined"!=typeof global&&null!=global?global:e};$jscomp.global=$jscomp.getGlobal(this);$jscomp.SYMBOL_PREFIX="jscomp_symbol_";
$jscomp.initSymbol=function(){$jscomp.initSymbol=function(){};$jscomp.global.Symbol||($jscomp.global.Symbol=$jscomp.Symbol)};$jscomp.symbolCounter_=0;$jscomp.Symbol=function(e){return $jscomp.SYMBOL_PREFIX+(e||"")+$jscomp.symbolCounter_++};
$jscomp.initSymbolIterator=function(){$jscomp.initSymbol();var e=$jscomp.global.Symbol.iterator;e||(e=$jscomp.global.Symbol.iterator=$jscomp.global.Symbol("iterator"));"function"!=typeof Array.prototype[e]&&$jscomp.defineProperty(Array.prototype,e,{configurable:!0,writable:!0,value:function(){return $jscomp.arrayIterator(this)}});$jscomp.initSymbolIterator=function(){}};$jscomp.arrayIterator=function(e){var r=0;return $jscomp.iteratorPrototype(function(){return r<e.length?{done:!1,value:e[r++]}:{done:!0}})};
$jscomp.iteratorPrototype=function(e){$jscomp.initSymbolIterator();e={next:e};e[$jscomp.global.Symbol.iterator]=function(){return this};return e};$jscomp.array=$jscomp.array||{};$jscomp.iteratorFromArray=function(e,r){$jscomp.initSymbolIterator();e instanceof String&&(e+="");var p=0,m={next:function(){if(p<e.length){var u=p++;return{value:r(u,e[u]),done:!1}}m.next=function(){return{done:!0,value:void 0}};return m.next()}};m[Symbol.iterator]=function(){return m};return m};
$jscomp.polyfill=function(e,r,p,m){if(r){p=$jscomp.global;e=e.split(".");for(m=0;m<e.length-1;m++){var u=e[m];u in p||(p[u]={});p=p[u]}e=e[e.length-1];m=p[e];r=r(m);r!=m&&null!=r&&$jscomp.defineProperty(p,e,{configurable:!0,writable:!0,value:r})}};$jscomp.polyfill("Array.prototype.keys",function(e){return e?e:function(){return $jscomp.iteratorFromArray(this,function(e){return e})}},"es6-impl","es3");var $jscomp$this=this;
(function(e,r){"function"===typeof define&&define.amd?define([],r):"object"===typeof module&&module.exports?module.exports=r():e.anime=r()})(this,function(){function e(a){if(!h.col(a))try{return document.querySelectorAll(a)}catch(c){}}function r(a,c){for(var d=a.length,b=2<=arguments.length?arguments[1]:void 0,f=[],n=0;n<d;n++)if(n in a){var k=a[n];c.call(b,k,n,a)&&f.push(k)}return f}function p(a){return a.reduce(function(a,d){return a.concat(h.arr(d)?p(d):d)},[])}function m(a){if(h.arr(a))return a;
h.str(a)&&(a=e(a)||a);return a instanceof NodeList||a instanceof HTMLCollection?[].slice.call(a):[a]}function u(a,c){return a.some(function(a){return a===c})}function C(a){var c={},d;for(d in a)c[d]=a[d];return c}function D(a,c){var d=C(a),b;for(b in a)d[b]=c.hasOwnProperty(b)?c[b]:a[b];return d}function z(a,c){var d=C(a),b;for(b in c)d[b]=h.und(a[b])?c[b]:a[b];return d}function T(a){a=a.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,function(a,c,d,k){return c+c+d+d+k+k});var c=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(a);
a=parseInt(c[1],16);var d=parseInt(c[2],16),c=parseInt(c[3],16);return"rgba("+a+","+d+","+c+",1)"}function U(a){function c(a,c,b){0>b&&(b+=1);1<b&&--b;return b<1/6?a+6*(c-a)*b:.5>b?c:b<2/3?a+(c-a)*(2/3-b)*6:a}var d=/hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(a)||/hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%,\s*([\d.]+)\)/g.exec(a);a=parseInt(d[1])/360;var b=parseInt(d[2])/100,f=parseInt(d[3])/100,d=d[4]||1;if(0==b)f=b=a=f;else{var n=.5>f?f*(1+b):f+b-f*b,k=2*f-n,f=c(k,n,a+1/3),b=c(k,n,a);a=c(k,n,a-1/3)}return"rgba("+
255*f+","+255*b+","+255*a+","+d+")"}function y(a){if(a=/([\+\-]?[0-9#\.]+)(%|px|pt|em|rem|in|cm|mm|ex|ch|pc|vw|vh|vmin|vmax|deg|rad|turn)?$/.exec(a))return a[2]}function V(a){if(-1<a.indexOf("translate")||"perspective"===a)return"px";if(-1<a.indexOf("rotate")||-1<a.indexOf("skew"))return"deg"}function I(a,c){return h.fnc(a)?a(c.target,c.id,c.total):a}function E(a,c){if(c in a.style)return getComputedStyle(a).getPropertyValue(c.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase())||"0"}function J(a,c){if(h.dom(a)&&
u(W,c))return"transform";if(h.dom(a)&&(a.getAttribute(c)||h.svg(a)&&a[c]))return"attribute";if(h.dom(a)&&"transform"!==c&&E(a,c))return"css";if(null!=a[c])return"object"}function X(a,c){var d=V(c),d=-1<c.indexOf("scale")?1:0+d;a=a.style.transform;if(!a)return d;for(var b=[],f=[],n=[],k=/(\w+)\((.+?)\)/g;b=k.exec(a);)f.push(b[1]),n.push(b[2]);a=r(n,function(a,b){return f[b]===c});return a.length?a[0]:d}function K(a,c){switch(J(a,c)){case "transform":return X(a,c);case "css":return E(a,c);case "attribute":return a.getAttribute(c)}return a[c]||
0}function L(a,c){var d=/^(\*=|\+=|-=)/.exec(a);if(!d)return a;var b=y(a)||0;c=parseFloat(c);a=parseFloat(a.replace(d[0],""));switch(d[0][0]){case "+":return c+a+b;case "-":return c-a+b;case "*":return c*a+b}}function F(a,c){return Math.sqrt(Math.pow(c.x-a.x,2)+Math.pow(c.y-a.y,2))}function M(a){a=a.points;for(var c=0,d,b=0;b<a.numberOfItems;b++){var f=a.getItem(b);0<b&&(c+=F(d,f));d=f}return c}function N(a){if(a.getTotalLength)return a.getTotalLength();switch(a.tagName.toLowerCase()){case "circle":return 2*
Math.PI*a.getAttribute("r");case "rect":return 2*a.getAttribute("width")+2*a.getAttribute("height");case "line":return F({x:a.getAttribute("x1"),y:a.getAttribute("y1")},{x:a.getAttribute("x2"),y:a.getAttribute("y2")});case "polyline":return M(a);case "polygon":var c=a.points;return M(a)+F(c.getItem(c.numberOfItems-1),c.getItem(0))}}function Y(a,c){function d(b){b=void 0===b?0:b;return a.el.getPointAtLength(1<=c+b?c+b:0)}var b=d(),f=d(-1),n=d(1);switch(a.property){case "x":return b.x;case "y":return b.y;
case "angle":return 180*Math.atan2(n.y-f.y,n.x-f.x)/Math.PI}}function O(a,c){var d=/-?\d*\.?\d+/g,b;b=h.pth(a)?a.totalLength:a;if(h.col(b))if(h.rgb(b)){var f=/rgb\((\d+,\s*[\d]+,\s*[\d]+)\)/g.exec(b);b=f?"rgba("+f[1]+",1)":b}else b=h.hex(b)?T(b):h.hsl(b)?U(b):void 0;else f=(f=y(b))?b.substr(0,b.length-f.length):b,b=c&&!/\s/g.test(b)?f+c:f;b+="";return{original:b,numbers:b.match(d)?b.match(d).map(Number):[0],strings:h.str(a)||c?b.split(d):[]}}function P(a){a=a?p(h.arr(a)?a.map(m):m(a)):[];return r(a,
function(a,d,b){return b.indexOf(a)===d})}function Z(a){var c=P(a);return c.map(function(a,b){return{target:a,id:b,total:c.length}})}function aa(a,c){var d=C(c);if(h.arr(a)){var b=a.length;2!==b||h.obj(a[0])?h.fnc(c.duration)||(d.duration=c.duration/b):a={value:a}}return m(a).map(function(a,b){b=b?0:c.delay;a=h.obj(a)&&!h.pth(a)?a:{value:a};h.und(a.delay)&&(a.delay=b);return a}).map(function(a){return z(a,d)})}function ba(a,c){var d={},b;for(b in a){var f=I(a[b],c);h.arr(f)&&(f=f.map(function(a){return I(a,
c)}),1===f.length&&(f=f[0]));d[b]=f}d.duration=parseFloat(d.duration);d.delay=parseFloat(d.delay);return d}function ca(a){return h.arr(a)?A.apply(this,a):Q[a]}function da(a,c){var d;return a.tweens.map(function(b){b=ba(b,c);var f=b.value,e=K(c.target,a.name),k=d?d.to.original:e,k=h.arr(f)?f[0]:k,w=L(h.arr(f)?f[1]:f,k),e=y(w)||y(k)||y(e);b.from=O(k,e);b.to=O(w,e);b.start=d?d.end:a.offset;b.end=b.start+b.delay+b.duration;b.easing=ca(b.easing);b.elasticity=(1E3-Math.min(Math.max(b.elasticity,1),999))/
1E3;b.isPath=h.pth(f);b.isColor=h.col(b.from.original);b.isColor&&(b.round=1);return d=b})}function ea(a,c){return r(p(a.map(function(a){return c.map(function(b){var c=J(a.target,b.name);if(c){var d=da(b,a);b={type:c,property:b.name,animatable:a,tweens:d,duration:d[d.length-1].end,delay:d[0].delay}}else b=void 0;return b})})),function(a){return!h.und(a)})}function R(a,c,d,b){var f="delay"===a;return c.length?(f?Math.min:Math.max).apply(Math,c.map(function(b){return b[a]})):f?b.delay:d.offset+b.delay+
b.duration}function fa(a){var c=D(ga,a),d=D(S,a),b=Z(a.targets),f=[],e=z(c,d),k;for(k in a)e.hasOwnProperty(k)||"targets"===k||f.push({name:k,offset:e.offset,tweens:aa(a[k],d)});a=ea(b,f);return z(c,{children:[],animatables:b,animations:a,duration:R("duration",a,c,d),delay:R("delay",a,c,d)})}function q(a){function c(){return window.Promise&&new Promise(function(a){return p=a})}function d(a){return g.reversed?g.duration-a:a}function b(a){for(var b=0,c={},d=g.animations,f=d.length;b<f;){var e=d[b],
k=e.animatable,h=e.tweens,n=h.length-1,l=h[n];n&&(l=r(h,function(b){return a<b.end})[0]||l);for(var h=Math.min(Math.max(a-l.start-l.delay,0),l.duration)/l.duration,w=isNaN(h)?1:l.easing(h,l.elasticity),h=l.to.strings,p=l.round,n=[],m=void 0,m=l.to.numbers.length,t=0;t<m;t++){var x=void 0,x=l.to.numbers[t],q=l.from.numbers[t],x=l.isPath?Y(l.value,w*x):q+w*(x-q);p&&(l.isColor&&2<t||(x=Math.round(x*p)/p));n.push(x)}if(l=h.length)for(m=h[0],w=0;w<l;w++)p=h[w+1],t=n[w],isNaN(t)||(m=p?m+(t+p):m+(t+" "));
else m=n[0];ha[e.type](k.target,e.property,m,c,k.id);e.currentValue=m;b++}if(b=Object.keys(c).length)for(d=0;d<b;d++)H||(H=E(document.body,"transform")?"transform":"-webkit-transform"),g.animatables[d].target.style[H]=c[d].join(" ");g.currentTime=a;g.progress=a/g.duration*100}function f(a){if(g[a])g[a](g)}function e(){g.remaining&&!0!==g.remaining&&g.remaining--}function k(a){var k=g.duration,n=g.offset,w=n+g.delay,r=g.currentTime,x=g.reversed,q=d(a);if(g.children.length){var u=g.children,v=u.length;
if(q>=g.currentTime)for(var G=0;G<v;G++)u[G].seek(q);else for(;v--;)u[v].seek(q)}if(q>=w||!k)g.began||(g.began=!0,f("begin")),f("run");if(q>n&&q<k)b(q);else if(q<=n&&0!==r&&(b(0),x&&e()),q>=k&&r!==k||!k)b(k),x||e();f("update");a>=k&&(g.remaining?(t=h,"alternate"===g.direction&&(g.reversed=!g.reversed)):(g.pause(),g.completed||(g.completed=!0,f("complete"),"Promise"in window&&(p(),m=c()))),l=0)}a=void 0===a?{}:a;var h,t,l=0,p=null,m=c(),g=fa(a);g.reset=function(){var a=g.direction,c=g.loop;g.currentTime=
0;g.progress=0;g.paused=!0;g.began=!1;g.completed=!1;g.reversed="reverse"===a;g.remaining="alternate"===a&&1===c?2:c;b(0);for(a=g.children.length;a--;)g.children[a].reset()};g.tick=function(a){h=a;t||(t=h);k((l+h-t)*q.speed)};g.seek=function(a){k(d(a))};g.pause=function(){var a=v.indexOf(g);-1<a&&v.splice(a,1);g.paused=!0};g.play=function(){g.paused&&(g.paused=!1,t=0,l=d(g.currentTime),v.push(g),B||ia())};g.reverse=function(){g.reversed=!g.reversed;t=0;l=d(g.currentTime)};g.restart=function(){g.pause();
g.reset();g.play()};g.finished=m;g.reset();g.autoplay&&g.play();return g}var ga={update:void 0,begin:void 0,run:void 0,complete:void 0,loop:1,direction:"normal",autoplay:!0,offset:0},S={duration:1E3,delay:0,easing:"easeOutElastic",elasticity:500,round:0},W="translateX translateY translateZ rotate rotateX rotateY rotateZ scale scaleX scaleY scaleZ skewX skewY perspective".split(" "),H,h={arr:function(a){return Array.isArray(a)},obj:function(a){return-1<Object.prototype.toString.call(a).indexOf("Object")},
pth:function(a){return h.obj(a)&&a.hasOwnProperty("totalLength")},svg:function(a){return a instanceof SVGElement},dom:function(a){return a.nodeType||h.svg(a)},str:function(a){return"string"===typeof a},fnc:function(a){return"function"===typeof a},und:function(a){return"undefined"===typeof a},hex:function(a){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a)},rgb:function(a){return/^rgb/.test(a)},hsl:function(a){return/^hsl/.test(a)},col:function(a){return h.hex(a)||h.rgb(a)||h.hsl(a)}},A=function(){function a(a,
d,b){return(((1-3*b+3*d)*a+(3*b-6*d))*a+3*d)*a}return function(c,d,b,f){if(0<=c&&1>=c&&0<=b&&1>=b){var e=new Float32Array(11);if(c!==d||b!==f)for(var k=0;11>k;++k)e[k]=a(.1*k,c,b);return function(k){if(c===d&&b===f)return k;if(0===k)return 0;if(1===k)return 1;for(var h=0,l=1;10!==l&&e[l]<=k;++l)h+=.1;--l;var l=h+(k-e[l])/(e[l+1]-e[l])*.1,n=3*(1-3*b+3*c)*l*l+2*(3*b-6*c)*l+3*c;if(.001<=n){for(h=0;4>h;++h){n=3*(1-3*b+3*c)*l*l+2*(3*b-6*c)*l+3*c;if(0===n)break;var m=a(l,c,b)-k,l=l-m/n}k=l}else if(0===
n)k=l;else{var l=h,h=h+.1,g=0;do m=l+(h-l)/2,n=a(m,c,b)-k,0<n?h=m:l=m;while(1e-7<Math.abs(n)&&10>++g);k=m}return a(k,d,f)}}}}(),Q=function(){function a(a,b){return 0===a||1===a?a:-Math.pow(2,10*(a-1))*Math.sin(2*(a-1-b/(2*Math.PI)*Math.asin(1))*Math.PI/b)}var c="Quad Cubic Quart Quint Sine Expo Circ Back Elastic".split(" "),d={In:[[.55,.085,.68,.53],[.55,.055,.675,.19],[.895,.03,.685,.22],[.755,.05,.855,.06],[.47,0,.745,.715],[.95,.05,.795,.035],[.6,.04,.98,.335],[.6,-.28,.735,.045],a],Out:[[.25,
.46,.45,.94],[.215,.61,.355,1],[.165,.84,.44,1],[.23,1,.32,1],[.39,.575,.565,1],[.19,1,.22,1],[.075,.82,.165,1],[.175,.885,.32,1.275],function(b,c){return 1-a(1-b,c)}],InOut:[[.455,.03,.515,.955],[.645,.045,.355,1],[.77,0,.175,1],[.86,0,.07,1],[.445,.05,.55,.95],[1,0,0,1],[.785,.135,.15,.86],[.68,-.55,.265,1.55],function(b,c){return.5>b?a(2*b,c)/2:1-a(-2*b+2,c)/2}]},b={linear:A(.25,.25,.75,.75)},f={},e;for(e in d)f.type=e,d[f.type].forEach(function(a){return function(d,f){b["ease"+a.type+c[f]]=h.fnc(d)?
d:A.apply($jscomp$this,d)}}(f)),f={type:f.type};return b}(),ha={css:function(a,c,d){return a.style[c]=d},attribute:function(a,c,d){return a.setAttribute(c,d)},object:function(a,c,d){return a[c]=d},transform:function(a,c,d,b,f){b[f]||(b[f]=[]);b[f].push(c+"("+d+")")}},v=[],B=0,ia=function(){function a(){B=requestAnimationFrame(c)}function c(c){var b=v.length;if(b){for(var d=0;d<b;)v[d]&&v[d].tick(c),d++;a()}else cancelAnimationFrame(B),B=0}return a}();q.version="2.2.0";q.speed=1;q.running=v;q.remove=
function(a){a=P(a);for(var c=v.length;c--;)for(var d=v[c],b=d.animations,f=b.length;f--;)u(a,b[f].animatable.target)&&(b.splice(f,1),b.length||d.pause())};q.getValue=K;q.path=function(a,c){var d=h.str(a)?e(a)[0]:a,b=c||100;return function(a){return{el:d,property:a,totalLength:N(d)*(b/100)}}};q.setDashoffset=function(a){var c=N(a);a.setAttribute("stroke-dasharray",c);return c};q.bezier=A;q.easings=Q;q.timeline=function(a){var c=q(a);c.pause();c.duration=0;c.add=function(d){c.children.forEach(function(a){a.began=
!0;a.completed=!0});m(d).forEach(function(b){var d=z(b,D(S,a||{}));d.targets=d.targets||a.targets;b=c.duration;var e=d.offset;d.autoplay=!1;d.direction=c.direction;d.offset=h.und(e)?b:L(e,b);c.began=!0;c.completed=!0;c.seek(d.offset);d=q(d);d.began=!0;d.completed=!0;d.duration>b&&(c.duration=d.duration);c.children.push(d)});c.seek(0);c.reset();c.autoplay&&c.restart();return c};return c};q.random=function(a,c){return Math.floor(Math.random()*(c-a+1))+a};return q});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
/**
 * sticky-sidebar - A JavaScript plugin for making smart and high performance.
 * @version v3.3.1
 * @link https://github.com/abouolia/sticky-sidebar
 * @author Ahmed Bouhuolia
 * @license The MIT License (MIT)
**/
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.StickySidebar=e()}(this,function(){"use strict";"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function t(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function e(t,e){return t(e={exports:{}},e.exports),e.exports}var i=e(function(t,e){(function(t){Object.defineProperty(t,"__esModule",{value:!0});var l,n,e=function(){function n(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}return function(t,e,i){return e&&n(t.prototype,e),i&&n(t,i),t}}(),i=(l=".stickySidebar",n={topSpacing:0,bottomSpacing:0,containerSelector:!1,innerWrapperSelector:".inner-wrapper-sticky",stickyClass:"is-affixed",resizeSensor:!0,minWidth:!1},function(){function c(t){var e=this,i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,c),this.options=c.extend(n,i),this.sidebar="string"==typeof t?document.querySelector(t):t,void 0===this.sidebar)throw new Error("There is no specific sidebar element.");this.sidebarInner=!1,this.container=this.sidebar.parentElement,this.affixedType="STATIC",this.direction="down",this.support={transform:!1,transform3d:!1},this._initialized=!1,this._reStyle=!1,this._breakpoint=!1,this.dimensions={translateY:0,maxTranslateY:0,topSpacing:0,lastTopSpacing:0,bottomSpacing:0,lastBottomSpacing:0,sidebarHeight:0,sidebarWidth:0,containerTop:0,containerHeight:0,viewportHeight:0,viewportTop:0,lastViewportTop:0},["handleEvent"].forEach(function(t){e[t]=e[t].bind(e)}),this.initialize()}return e(c,[{key:"initialize",value:function(){var i=this;if(this._setSupportFeatures(),this.options.innerWrapperSelector&&(this.sidebarInner=this.sidebar.querySelector(this.options.innerWrapperSelector),null===this.sidebarInner&&(this.sidebarInner=!1)),!this.sidebarInner){var t=document.createElement("div");for(t.setAttribute("class","inner-wrapper-sticky"),this.sidebar.appendChild(t);this.sidebar.firstChild!=t;)t.appendChild(this.sidebar.firstChild);this.sidebarInner=this.sidebar.querySelector(".inner-wrapper-sticky")}if(this.options.containerSelector){var e=document.querySelectorAll(this.options.containerSelector);if((e=Array.prototype.slice.call(e)).forEach(function(t,e){t.contains(i.sidebar)&&(i.container=t)}),!e.length)throw new Error("The container does not contains on the sidebar.")}"function"!=typeof this.options.topSpacing&&(this.options.topSpacing=parseInt(this.options.topSpacing)||0),"function"!=typeof this.options.bottomSpacing&&(this.options.bottomSpacing=parseInt(this.options.bottomSpacing)||0),this._widthBreakpoint(),this.calcDimensions(),this.stickyPosition(),this.bindEvents(),this._initialized=!0}},{key:"bindEvents",value:function(){window.addEventListener("resize",this,{passive:!0,capture:!1}),window.addEventListener("scroll",this,{passive:!0,capture:!1}),this.sidebar.addEventListener("update"+l,this),this.options.resizeSensor&&"undefined"!=typeof ResizeSensor&&(new ResizeSensor(this.sidebarInner,this.handleEvent),new ResizeSensor(this.container,this.handleEvent))}},{key:"handleEvent",value:function(t){this.updateSticky(t)}},{key:"calcDimensions",value:function(){if(!this._breakpoint){var t=this.dimensions;t.containerTop=c.offsetRelative(this.container).top,t.containerHeight=this.container.clientHeight,t.containerBottom=t.containerTop+t.containerHeight,t.sidebarHeight=this.sidebarInner.offsetHeight,t.sidebarWidth=this.sidebarInner.offsetWidth,t.viewportHeight=window.innerHeight,t.maxTranslateY=t.containerHeight-t.sidebarHeight,this._calcDimensionsWithScroll()}}},{key:"_calcDimensionsWithScroll",value:function(){var t=this.dimensions;t.sidebarLeft=c.offsetRelative(this.sidebar).left,t.viewportTop=document.documentElement.scrollTop||document.body.scrollTop,t.viewportBottom=t.viewportTop+t.viewportHeight,t.viewportLeft=document.documentElement.scrollLeft||document.body.scrollLeft,t.topSpacing=this.options.topSpacing,t.bottomSpacing=this.options.bottomSpacing,"function"==typeof t.topSpacing&&(t.topSpacing=parseInt(t.topSpacing(this.sidebar))||0),"function"==typeof t.bottomSpacing&&(t.bottomSpacing=parseInt(t.bottomSpacing(this.sidebar))||0),"VIEWPORT-TOP"===this.affixedType?t.topSpacing<t.lastTopSpacing&&(t.translateY+=t.lastTopSpacing-t.topSpacing,this._reStyle=!0):"VIEWPORT-BOTTOM"===this.affixedType&&t.bottomSpacing<t.lastBottomSpacing&&(t.translateY+=t.lastBottomSpacing-t.bottomSpacing,this._reStyle=!0),t.lastTopSpacing=t.topSpacing,t.lastBottomSpacing=t.bottomSpacing}},{key:"isSidebarFitsViewport",value:function(){var t=this.dimensions,e="down"===this.scrollDirection?t.lastBottomSpacing:t.lastTopSpacing;return this.dimensions.sidebarHeight+e<this.dimensions.viewportHeight}},{key:"observeScrollDir",value:function(){var t=this.dimensions;if(t.lastViewportTop!==t.viewportTop){var e="down"===this.direction?Math.min:Math.max;t.viewportTop===e(t.viewportTop,t.lastViewportTop)&&(this.direction="down"===this.direction?"up":"down")}}},{key:"getAffixType",value:function(){this._calcDimensionsWithScroll();var t=this.dimensions,e=t.viewportTop+t.topSpacing,i=this.affixedType;return e<=t.containerTop||t.containerHeight<=t.sidebarHeight?(t.translateY=0,i="STATIC"):i="up"===this.direction?this._getAffixTypeScrollingUp():this._getAffixTypeScrollingDown(),t.translateY=Math.max(0,t.translateY),t.translateY=Math.min(t.containerHeight,t.translateY),t.translateY=Math.round(t.translateY),t.lastViewportTop=t.viewportTop,i}},{key:"_getAffixTypeScrollingDown",value:function(){var t=this.dimensions,e=t.sidebarHeight+t.containerTop,i=t.viewportTop+t.topSpacing,n=t.viewportBottom-t.bottomSpacing,o=this.affixedType;return this.isSidebarFitsViewport()?t.sidebarHeight+i>=t.containerBottom?(t.translateY=t.containerBottom-e,o="CONTAINER-BOTTOM"):i>=t.containerTop&&(t.translateY=i-t.containerTop,o="VIEWPORT-TOP"):t.containerBottom<=n?(t.translateY=t.containerBottom-e,o="CONTAINER-BOTTOM"):e+t.translateY<=n?(t.translateY=n-e,o="VIEWPORT-BOTTOM"):t.containerTop+t.translateY<=i&&0!==t.translateY&&t.maxTranslateY!==t.translateY&&(o="VIEWPORT-UNBOTTOM"),o}},{key:"_getAffixTypeScrollingUp",value:function(){var t=this.dimensions,e=t.sidebarHeight+t.containerTop,i=t.viewportTop+t.topSpacing,n=t.viewportBottom-t.bottomSpacing,o=this.affixedType;return i<=t.translateY+t.containerTop?(t.translateY=i-t.containerTop,o="VIEWPORT-TOP"):t.containerBottom<=n?(t.translateY=t.containerBottom-e,o="CONTAINER-BOTTOM"):this.isSidebarFitsViewport()||t.containerTop<=i&&0!==t.translateY&&t.maxTranslateY!==t.translateY&&(o="VIEWPORT-UNBOTTOM"),o}},{key:"_getStyle",value:function(t){if(void 0!==t){var e={inner:{},outer:{}},i=this.dimensions;switch(t){case"VIEWPORT-TOP":e.inner={position:"fixed",top:i.topSpacing,left:i.sidebarLeft-i.viewportLeft,width:i.sidebarWidth};break;case"VIEWPORT-BOTTOM":e.inner={position:"fixed",top:"auto",left:i.sidebarLeft,bottom:i.bottomSpacing,width:i.sidebarWidth};break;case"CONTAINER-BOTTOM":case"VIEWPORT-UNBOTTOM":var n=this._getTranslate(0,i.translateY+"px");e.inner=n?{transform:n}:{position:"absolute",top:i.translateY,width:i.sidebarWidth}}switch(t){case"VIEWPORT-TOP":case"VIEWPORT-BOTTOM":case"VIEWPORT-UNBOTTOM":case"CONTAINER-BOTTOM":e.outer={height:i.sidebarHeight,position:"relative"}}return e.outer=c.extend({height:"",position:""},e.outer),e.inner=c.extend({position:"relative",top:"",left:"",bottom:"",width:"",transform:""},e.inner),e}}},{key:"stickyPosition",value:function(t){if(!this._breakpoint){t=this._reStyle||t||!1,this.options.topSpacing,this.options.bottomSpacing;var e=this.getAffixType(),i=this._getStyle(e);if((this.affixedType!=e||t)&&e){var n="affix."+e.toLowerCase().replace("viewport-","")+l;for(var o in c.eventTrigger(this.sidebar,n),"STATIC"===e?c.removeClass(this.sidebar,this.options.stickyClass):c.addClass(this.sidebar,this.options.stickyClass),i.outer){var s="number"==typeof i.outer[o]?"px":"";this.sidebar.style[o]=i.outer[o]+s}for(var r in i.inner){var a="number"==typeof i.inner[r]?"px":"";this.sidebarInner.style[r]=i.inner[r]+a}var p="affixed."+e.toLowerCase().replace("viewport-","")+l;c.eventTrigger(this.sidebar,p)}else this._initialized&&(this.sidebarInner.style.left=i.inner.left);this.affixedType=e}}},{key:"_widthBreakpoint",value:function(){window.innerWidth<=this.options.minWidth?(this._breakpoint=!0,this.affixedType="STATIC",this.sidebar.removeAttribute("style"),c.removeClass(this.sidebar,this.options.stickyClass),this.sidebarInner.removeAttribute("style")):this._breakpoint=!1}},{key:"updateSticky",value:function(){var t,e=this,i=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};this._running||(this._running=!0,t=i.type,requestAnimationFrame(function(){switch(t){case"scroll":e._calcDimensionsWithScroll(),e.observeScrollDir(),e.stickyPosition();break;case"resize":default:e._widthBreakpoint(),e.calcDimensions(),e.stickyPosition(!0)}e._running=!1}))}},{key:"_setSupportFeatures",value:function(){var t=this.support;t.transform=c.supportTransform(),t.transform3d=c.supportTransform(!0)}},{key:"_getTranslate",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:0;return this.support.transform3d?"translate3d("+t+", "+e+", "+i+")":!!this.support.translate&&"translate("+t+", "+e+")"}},{key:"destroy",value:function(){window.removeEventListener("resize",this,{capture:!1}),window.removeEventListener("scroll",this,{capture:!1}),this.sidebar.classList.remove(this.options.stickyClass),this.sidebar.style.minHeight="",this.sidebar.removeEventListener("update"+l,this);var t={inner:{},outer:{}};for(var e in t.inner={position:"",top:"",left:"",bottom:"",width:"",transform:""},t.outer={height:"",position:""},t.outer)this.sidebar.style[e]=t.outer[e];for(var i in t.inner)this.sidebarInner.style[i]=t.inner[i];this.options.resizeSensor&&"undefined"!=typeof ResizeSensor&&(ResizeSensor.detach(this.sidebarInner,this.handleEvent),ResizeSensor.detach(this.container,this.handleEvent))}}],[{key:"supportTransform",value:function(t){var i=!1,e=t?"perspective":"transform",n=e.charAt(0).toUpperCase()+e.slice(1),o=document.createElement("support").style;return(e+" "+["Webkit","Moz","O","ms"].join(n+" ")+n).split(" ").forEach(function(t,e){if(void 0!==o[t])return i=t,!1}),i}},{key:"eventTrigger",value:function(t,e,i){try{var n=new CustomEvent(e,{detail:i})}catch(t){(n=document.createEvent("CustomEvent")).initCustomEvent(e,!0,!0,i)}t.dispatchEvent(n)}},{key:"extend",value:function(t,e){var i={};for(var n in t)void 0!==e[n]?i[n]=e[n]:i[n]=t[n];return i}},{key:"offsetRelative",value:function(t){var e={left:0,top:0};do{var i=t.offsetTop,n=t.offsetLeft;isNaN(i)||(e.top+=i),isNaN(n)||(e.left+=n),t="BODY"===t.tagName?t.parentElement:t.offsetParent}while(t);return e}},{key:"addClass",value:function(t,e){c.hasClass(t,e)||(t.classList?t.classList.add(e):t.className+=" "+e)}},{key:"removeClass",value:function(t,e){c.hasClass(t,e)&&(t.classList?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," "))}},{key:"hasClass",value:function(t,e){return t.classList?t.classList.contains(e):new RegExp("(^| )"+e+"( |$)","gi").test(t.className)}},{key:"defaults",get:function(){return n}}]),c}());t.default=i,window.StickySidebar=i})(e)});return t(i),t(e(function(t,e){(function(t){var e,s=(e=t)&&e.__esModule?e:{default:e};!function(){if("undefined"!=typeof window){var n=window.$||window.jQuery||window.Zepto,o="stickySidebar";if(n){n.fn.stickySidebar=function(i){return this.each(function(){var t=n(this),e=n(this).data(o);if(e||(e=new s.default(this,"object"==typeof i&&i),t.data(o,e)),"string"==typeof i){if(void 0===e[i]&&-1===["destroy","updateSticky"].indexOf(i))throw new Error('No method named "'+i+'"');e[i]()}})},n.fn.stickySidebar.Constructor=s.default;var t=n.fn.stickySidebar;n.fn.stickySidebar.noConflict=function(){return n.fn.stickySidebar=t,this}}}}()})(i)}))});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
/*!
 * Masonry PACKAGED v4.1.1
 * Cascading grid layout library
 * http://masonry.desandro.com
 * MIT License
 * by David DeSandro
 */

!function(t,e){"function"==typeof define&&define.amd?define("jquery-bridget/jquery-bridget",["jquery"],function(i){return e(t,i)}):"object"==typeof module&&module.exports?module.exports=e(t,require("jquery")):t.jQueryBridget=e(t,t.jQuery)}(window,function(t,e){"use strict";function i(i,r,a){function h(t,e,n){var o,r="$()."+i+'("'+e+'")';return t.each(function(t,h){var u=a.data(h,i);if(!u)return void s(i+" not initialized. Cannot call methods, i.e. "+r);var d=u[e];if(!d||"_"==e.charAt(0))return void s(r+" is not a valid method");var l=d.apply(u,n);o=void 0===o?l:o}),void 0!==o?o:t}function u(t,e){t.each(function(t,n){var o=a.data(n,i);o?(o.option(e),o._init()):(o=new r(n,e),a.data(n,i,o))})}a=a||e||t.jQuery,a&&(r.prototype.option||(r.prototype.option=function(t){a.isPlainObject(t)&&(this.options=a.extend(!0,this.options,t))}),a.fn[i]=function(t){if("string"==typeof t){var e=o.call(arguments,1);return h(this,t,e)}return u(this,t),this},n(a))}function n(t){!t||t&&t.bridget||(t.bridget=i)}var o=Array.prototype.slice,r=t.console,s="undefined"==typeof r?function(){}:function(t){r.error(t)};return n(e||t.jQuery),i}),function(t,e){"function"==typeof define&&define.amd?define("ev-emitter/ev-emitter",e):"object"==typeof module&&module.exports?module.exports=e():t.EvEmitter=e()}("undefined"!=typeof window?window:this,function(){function t(){}var e=t.prototype;return e.on=function(t,e){if(t&&e){var i=this._events=this._events||{},n=i[t]=i[t]||[];return-1==n.indexOf(e)&&n.push(e),this}},e.once=function(t,e){if(t&&e){this.on(t,e);var i=this._onceEvents=this._onceEvents||{},n=i[t]=i[t]||{};return n[e]=!0,this}},e.off=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=i.indexOf(e);return-1!=n&&i.splice(n,1),this}},e.emitEvent=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=0,o=i[n];e=e||[];for(var r=this._onceEvents&&this._onceEvents[t];o;){var s=r&&r[o];s&&(this.off(t,o),delete r[o]),o.apply(this,e),n+=s?0:1,o=i[n]}return this}},t}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("get-size/get-size",[],function(){return e()}):"object"==typeof module&&module.exports?module.exports=e():t.getSize=e()}(window,function(){"use strict";function t(t){var e=parseFloat(t),i=-1==t.indexOf("%")&&!isNaN(e);return i&&e}function e(){}function i(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0;u>e;e++){var i=h[e];t[i]=0}return t}function n(t){var e=getComputedStyle(t);return e||a("Style returned "+e+". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1"),e}function o(){if(!d){d=!0;var e=document.createElement("div");e.style.width="200px",e.style.padding="1px 2px 3px 4px",e.style.borderStyle="solid",e.style.borderWidth="1px 2px 3px 4px",e.style.boxSizing="border-box";var i=document.body||document.documentElement;i.appendChild(e);var o=n(e);r.isBoxSizeOuter=s=200==t(o.width),i.removeChild(e)}}function r(e){if(o(),"string"==typeof e&&(e=document.querySelector(e)),e&&"object"==typeof e&&e.nodeType){var r=n(e);if("none"==r.display)return i();var a={};a.width=e.offsetWidth,a.height=e.offsetHeight;for(var d=a.isBorderBox="border-box"==r.boxSizing,l=0;u>l;l++){var c=h[l],f=r[c],m=parseFloat(f);a[c]=isNaN(m)?0:m}var p=a.paddingLeft+a.paddingRight,g=a.paddingTop+a.paddingBottom,y=a.marginLeft+a.marginRight,v=a.marginTop+a.marginBottom,_=a.borderLeftWidth+a.borderRightWidth,E=a.borderTopWidth+a.borderBottomWidth,z=d&&s,b=t(r.width);b!==!1&&(a.width=b+(z?0:p+_));var x=t(r.height);return x!==!1&&(a.height=x+(z?0:g+E)),a.innerWidth=a.width-(p+_),a.innerHeight=a.height-(g+E),a.outerWidth=a.width+y,a.outerHeight=a.height+v,a}}var s,a="undefined"==typeof console?e:function(t){console.error(t)},h=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"],u=h.length,d=!1;return r}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("desandro-matches-selector/matches-selector",e):"object"==typeof module&&module.exports?module.exports=e():t.matchesSelector=e()}(window,function(){"use strict";var t=function(){var t=Element.prototype;if(t.matches)return"matches";if(t.matchesSelector)return"matchesSelector";for(var e=["webkit","moz","ms","o"],i=0;i<e.length;i++){var n=e[i],o=n+"MatchesSelector";if(t[o])return o}}();return function(e,i){return e[t](i)}}),function(t,e){"function"==typeof define&&define.amd?define("fizzy-ui-utils/utils",["desandro-matches-selector/matches-selector"],function(i){return e(t,i)}):"object"==typeof module&&module.exports?module.exports=e(t,require("desandro-matches-selector")):t.fizzyUIUtils=e(t,t.matchesSelector)}(window,function(t,e){var i={};i.extend=function(t,e){for(var i in e)t[i]=e[i];return t},i.modulo=function(t,e){return(t%e+e)%e},i.makeArray=function(t){var e=[];if(Array.isArray(t))e=t;else if(t&&"number"==typeof t.length)for(var i=0;i<t.length;i++)e.push(t[i]);else e.push(t);return e},i.removeFrom=function(t,e){var i=t.indexOf(e);-1!=i&&t.splice(i,1)},i.getParent=function(t,i){for(;t!=document.body;)if(t=t.parentNode,e(t,i))return t},i.getQueryElement=function(t){return"string"==typeof t?document.querySelector(t):t},i.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},i.filterFindElements=function(t,n){t=i.makeArray(t);var o=[];return t.forEach(function(t){if(t instanceof HTMLElement){if(!n)return void o.push(t);e(t,n)&&o.push(t);for(var i=t.querySelectorAll(n),r=0;r<i.length;r++)o.push(i[r])}}),o},i.debounceMethod=function(t,e,i){var n=t.prototype[e],o=e+"Timeout";t.prototype[e]=function(){var t=this[o];t&&clearTimeout(t);var e=arguments,r=this;this[o]=setTimeout(function(){n.apply(r,e),delete r[o]},i||100)}},i.docReady=function(t){var e=document.readyState;"complete"==e||"interactive"==e?t():document.addEventListener("DOMContentLoaded",t)},i.toDashed=function(t){return t.replace(/(.)([A-Z])/g,function(t,e,i){return e+"-"+i}).toLowerCase()};var n=t.console;return i.htmlInit=function(e,o){i.docReady(function(){var r=i.toDashed(o),s="data-"+r,a=document.querySelectorAll("["+s+"]"),h=document.querySelectorAll(".js-"+r),u=i.makeArray(a).concat(i.makeArray(h)),d=s+"-options",l=t.jQuery;u.forEach(function(t){var i,r=t.getAttribute(s)||t.getAttribute(d);try{i=r&&JSON.parse(r)}catch(a){return void(n&&n.error("Error parsing "+s+" on "+t.className+": "+a))}var h=new e(t,i);l&&l.data(t,o,h)})})},i}),function(t,e){"function"==typeof define&&define.amd?define("outlayer/item",["ev-emitter/ev-emitter","get-size/get-size"],e):"object"==typeof module&&module.exports?module.exports=e(require("ev-emitter"),require("get-size")):(t.Outlayer={},t.Outlayer.Item=e(t.EvEmitter,t.getSize))}(window,function(t,e){"use strict";function i(t){for(var e in t)return!1;return e=null,!0}function n(t,e){t&&(this.element=t,this.layout=e,this.position={x:0,y:0},this._create())}function o(t){return t.replace(/([A-Z])/g,function(t){return"-"+t.toLowerCase()})}var r=document.documentElement.style,s="string"==typeof r.transition?"transition":"WebkitTransition",a="string"==typeof r.transform?"transform":"WebkitTransform",h={WebkitTransition:"webkitTransitionEnd",transition:"transitionend"}[s],u={transform:a,transition:s,transitionDuration:s+"Duration",transitionProperty:s+"Property",transitionDelay:s+"Delay"},d=n.prototype=Object.create(t.prototype);d.constructor=n,d._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"})},d.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},d.getSize=function(){this.size=e(this.element)},d.css=function(t){var e=this.element.style;for(var i in t){var n=u[i]||i;e[n]=t[i]}},d.getPosition=function(){var t=getComputedStyle(this.element),e=this.layout._getOption("originLeft"),i=this.layout._getOption("originTop"),n=t[e?"left":"right"],o=t[i?"top":"bottom"],r=this.layout.size,s=-1!=n.indexOf("%")?parseFloat(n)/100*r.width:parseInt(n,10),a=-1!=o.indexOf("%")?parseFloat(o)/100*r.height:parseInt(o,10);s=isNaN(s)?0:s,a=isNaN(a)?0:a,s-=e?r.paddingLeft:r.paddingRight,a-=i?r.paddingTop:r.paddingBottom,this.position.x=s,this.position.y=a},d.layoutPosition=function(){var t=this.layout.size,e={},i=this.layout._getOption("originLeft"),n=this.layout._getOption("originTop"),o=i?"paddingLeft":"paddingRight",r=i?"left":"right",s=i?"right":"left",a=this.position.x+t[o];e[r]=this.getXValue(a),e[s]="";var h=n?"paddingTop":"paddingBottom",u=n?"top":"bottom",d=n?"bottom":"top",l=this.position.y+t[h];e[u]=this.getYValue(l),e[d]="",this.css(e),this.emitEvent("layout",[this])},d.getXValue=function(t){var e=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&!e?t/this.layout.size.width*100+"%":t+"px"},d.getYValue=function(t){var e=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&e?t/this.layout.size.height*100+"%":t+"px"},d._transitionTo=function(t,e){this.getPosition();var i=this.position.x,n=this.position.y,o=parseInt(t,10),r=parseInt(e,10),s=o===this.position.x&&r===this.position.y;if(this.setPosition(t,e),s&&!this.isTransitioning)return void this.layoutPosition();var a=t-i,h=e-n,u={};u.transform=this.getTranslate(a,h),this.transition({to:u,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},d.getTranslate=function(t,e){var i=this.layout._getOption("originLeft"),n=this.layout._getOption("originTop");return t=i?t:-t,e=n?e:-e,"translate3d("+t+"px, "+e+"px, 0)"},d.goTo=function(t,e){this.setPosition(t,e),this.layoutPosition()},d.moveTo=d._transitionTo,d.setPosition=function(t,e){this.position.x=parseInt(t,10),this.position.y=parseInt(e,10)},d._nonTransition=function(t){this.css(t.to),t.isCleaning&&this._removeStyles(t.to);for(var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)},d.transition=function(t){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(t);var e=this._transn;for(var i in t.onTransitionEnd)e.onEnd[i]=t.onTransitionEnd[i];for(i in t.to)e.ingProperties[i]=!0,t.isCleaning&&(e.clean[i]=!0);if(t.from){this.css(t.from);var n=this.element.offsetHeight;n=null}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0};var l="opacity,"+o(a);d.enableTransition=function(){if(!this.isTransitioning){var t=this.layout.options.transitionDuration;t="number"==typeof t?t+"ms":t,this.css({transitionProperty:l,transitionDuration:t,transitionDelay:this.staggerDelay||0}),this.element.addEventListener(h,this,!1)}},d.onwebkitTransitionEnd=function(t){this.ontransitionend(t)},d.onotransitionend=function(t){this.ontransitionend(t)};var c={"-webkit-transform":"transform"};d.ontransitionend=function(t){if(t.target===this.element){var e=this._transn,n=c[t.propertyName]||t.propertyName;if(delete e.ingProperties[n],i(e.ingProperties)&&this.disableTransition(),n in e.clean&&(this.element.style[t.propertyName]="",delete e.clean[n]),n in e.onEnd){var o=e.onEnd[n];o.call(this),delete e.onEnd[n]}this.emitEvent("transitionEnd",[this])}},d.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(h,this,!1),this.isTransitioning=!1},d._removeStyles=function(t){var e={};for(var i in t)e[i]="";this.css(e)};var f={transitionProperty:"",transitionDuration:"",transitionDelay:""};return d.removeTransitionStyles=function(){this.css(f)},d.stagger=function(t){t=isNaN(t)?0:t,this.staggerDelay=t+"ms"},d.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this])},d.remove=function(){return s&&parseFloat(this.layout.options.transitionDuration)?(this.once("transitionEnd",function(){this.removeElem()}),void this.hide()):void this.removeElem()},d.reveal=function(){delete this.isHidden,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("visibleStyle");e[i]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:e})},d.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal")},d.getHideRevealTransitionEndProperty=function(t){var e=this.layout.options[t];if(e.opacity)return"opacity";for(var i in e)return i},d.hide=function(){this.isHidden=!0,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("hiddenStyle");e[i]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:e})},d.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"))},d.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""})},n}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("outlayer/outlayer",["ev-emitter/ev-emitter","get-size/get-size","fizzy-ui-utils/utils","./item"],function(i,n,o,r){return e(t,i,n,o,r)}):"object"==typeof module&&module.exports?module.exports=e(t,require("ev-emitter"),require("get-size"),require("fizzy-ui-utils"),require("./item")):t.Outlayer=e(t,t.EvEmitter,t.getSize,t.fizzyUIUtils,t.Outlayer.Item)}(window,function(t,e,i,n,o){"use strict";function r(t,e){var i=n.getQueryElement(t);if(!i)return void(h&&h.error("Bad element for "+this.constructor.namespace+": "+(i||t)));this.element=i,u&&(this.$element=u(this.element)),this.options=n.extend({},this.constructor.defaults),this.option(e);var o=++l;this.element.outlayerGUID=o,c[o]=this,this._create();var r=this._getOption("initLayout");r&&this.layout()}function s(t){function e(){t.apply(this,arguments)}return e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e}function a(t){if("number"==typeof t)return t;var e=t.match(/(^\d*\.?\d*)(\w*)/),i=e&&e[1],n=e&&e[2];if(!i.length)return 0;i=parseFloat(i);var o=m[n]||1;return i*o}var h=t.console,u=t.jQuery,d=function(){},l=0,c={};r.namespace="outlayer",r.Item=o,r.defaults={containerStyle:{position:"relative"},initLayout:!0,originLeft:!0,originTop:!0,resize:!0,resizeContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}};var f=r.prototype;n.extend(f,e.prototype),f.option=function(t){n.extend(this.options,t)},f._getOption=function(t){var e=this.constructor.compatOptions[t];return e&&void 0!==this.options[e]?this.options[e]:this.options[t]},r.compatOptions={initLayout:"isInitLayout",horizontal:"isHorizontal",layoutInstant:"isLayoutInstant",originLeft:"isOriginLeft",originTop:"isOriginTop",resize:"isResizeBound",resizeContainer:"isResizingContainer"},f._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),n.extend(this.element.style,this.options.containerStyle);var t=this._getOption("resize");t&&this.bindResize()},f.reloadItems=function(){this.items=this._itemize(this.element.children)},f._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,n=[],o=0;o<e.length;o++){var r=e[o],s=new i(r,this);n.push(s)}return n},f._filterFindItemElements=function(t){return n.filterFindElements(t,this.options.itemSelector)},f.getItemElements=function(){return this.items.map(function(t){return t.element})},f.layout=function(){this._resetLayout(),this._manageStamps();var t=this._getOption("layoutInstant"),e=void 0!==t?t:!this._isLayoutInited;this.layoutItems(this.items,e),this._isLayoutInited=!0},f._init=f.layout,f._resetLayout=function(){this.getSize()},f.getSize=function(){this.size=i(this.element)},f._getMeasurement=function(t,e){var n,o=this.options[t];o?("string"==typeof o?n=this.element.querySelector(o):o instanceof HTMLElement&&(n=o),this[t]=n?i(n)[e]:o):this[t]=0},f.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout()},f._getItemsForLayout=function(t){return t.filter(function(t){return!t.isIgnored})},f._layoutItems=function(t,e){if(this._emitCompleteOnItems("layout",t),t&&t.length){var i=[];t.forEach(function(t){var n=this._getItemLayoutPosition(t);n.item=t,n.isInstant=e||t.isLayoutInstant,i.push(n)},this),this._processLayoutQueue(i)}},f._getItemLayoutPosition=function(){return{x:0,y:0}},f._processLayoutQueue=function(t){this.updateStagger(),t.forEach(function(t,e){this._positionItem(t.item,t.x,t.y,t.isInstant,e)},this)},f.updateStagger=function(){var t=this.options.stagger;return null===t||void 0===t?void(this.stagger=0):(this.stagger=a(t),this.stagger)},f._positionItem=function(t,e,i,n,o){n?t.goTo(e,i):(t.stagger(o*this.stagger),t.moveTo(e,i))},f._postLayout=function(){this.resizeContainer()},f.resizeContainer=function(){var t=this._getOption("resizeContainer");if(t){var e=this._getContainerSize();e&&(this._setContainerMeasure(e.width,!0),this._setContainerMeasure(e.height,!1))}},f._getContainerSize=d,f._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?"width":"height"]=t+"px"}},f._emitCompleteOnItems=function(t,e){function i(){o.dispatchEvent(t+"Complete",null,[e])}function n(){s++,s==r&&i()}var o=this,r=e.length;if(!e||!r)return void i();var s=0;e.forEach(function(e){e.once(t,n)})},f.dispatchEvent=function(t,e,i){var n=e?[e].concat(i):i;if(this.emitEvent(t,n),u)if(this.$element=this.$element||u(this.element),e){var o=u.Event(e);o.type=t,this.$element.trigger(o,i)}else this.$element.trigger(t,i)},f.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0)},f.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored},f.stamp=function(t){t=this._find(t),t&&(this.stamps=this.stamps.concat(t),t.forEach(this.ignore,this))},f.unstamp=function(t){t=this._find(t),t&&t.forEach(function(t){n.removeFrom(this.stamps,t),this.unignore(t)},this)},f._find=function(t){return t?("string"==typeof t&&(t=this.element.querySelectorAll(t)),t=n.makeArray(t)):void 0},f._manageStamps=function(){this.stamps&&this.stamps.length&&(this._getBoundingRect(),this.stamps.forEach(this._manageStamp,this))},f._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)}},f._manageStamp=d,f._getElementOffset=function(t){var e=t.getBoundingClientRect(),n=this._boundingRect,o=i(t),r={left:e.left-n.left-o.marginLeft,top:e.top-n.top-o.marginTop,right:n.right-e.right-o.marginRight,bottom:n.bottom-e.bottom-o.marginBottom};return r},f.handleEvent=n.handleEvent,f.bindResize=function(){t.addEventListener("resize",this),this.isResizeBound=!0},f.unbindResize=function(){t.removeEventListener("resize",this),this.isResizeBound=!1},f.onresize=function(){this.resize()},n.debounceMethod(r,"onresize",100),f.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},f.needsResizeLayout=function(){var t=i(this.element),e=this.size&&t;return e&&t.innerWidth!==this.size.innerWidth},f.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},f.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e))},f.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i)}},f.reveal=function(t){if(this._emitCompleteOnItems("reveal",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.reveal()})}},f.hide=function(t){if(this._emitCompleteOnItems("hide",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.hide()})}},f.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e)},f.hideItemElements=function(t){var e=this.getItems(t);this.hide(e)},f.getItem=function(t){for(var e=0;e<this.items.length;e++){var i=this.items[e];if(i.element==t)return i}},f.getItems=function(t){t=n.makeArray(t);var e=[];return t.forEach(function(t){var i=this.getItem(t);i&&e.push(i)},this),e},f.remove=function(t){var e=this.getItems(t);this._emitCompleteOnItems("remove",e),e&&e.length&&e.forEach(function(t){t.remove(),n.removeFrom(this.items,t)},this)},f.destroy=function(){var t=this.element.style;t.height="",t.position="",t.width="",this.items.forEach(function(t){t.destroy()}),this.unbindResize();var e=this.element.outlayerGUID;delete c[e],delete this.element.outlayerGUID,u&&u.removeData(this.element,this.constructor.namespace)},r.data=function(t){t=n.getQueryElement(t);var e=t&&t.outlayerGUID;return e&&c[e]},r.create=function(t,e){var i=s(r);return i.defaults=n.extend({},r.defaults),n.extend(i.defaults,e),i.compatOptions=n.extend({},r.compatOptions),i.namespace=t,i.data=r.data,i.Item=s(o),n.htmlInit(i,t),u&&u.bridget&&u.bridget(t,i),i};var m={ms:1,s:1e3};return r.Item=o,r}),function(t,e){"function"==typeof define&&define.amd?define(["outlayer/outlayer","get-size/get-size"],e):"object"==typeof module&&module.exports?module.exports=e(require("outlayer"),require("get-size")):t.Masonry=e(t.Outlayer,t.getSize)}(window,function(t,e){var i=t.create("masonry");return i.compatOptions.fitWidth="isFitWidth",i.prototype._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns(),this.colYs=[];for(var t=0;t<this.cols;t++)this.colYs.push(0);this.maxY=0},i.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],i=t&&t.element;this.columnWidth=i&&e(i).outerWidth||this.containerWidth}var n=this.columnWidth+=this.gutter,o=this.containerWidth+this.gutter,r=o/n,s=n-o%n,a=s&&1>s?"round":"floor";r=Math[a](r),this.cols=Math.max(r,1)},i.prototype.getContainerWidth=function(){var t=this._getOption("fitWidth"),i=t?this.element.parentNode:this.element,n=e(i);this.containerWidth=n&&n.innerWidth},i.prototype._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth%this.columnWidth,i=e&&1>e?"round":"ceil",n=Math[i](t.size.outerWidth/this.columnWidth);n=Math.min(n,this.cols);for(var o=this._getColGroup(n),r=Math.min.apply(Math,o),s=o.indexOf(r),a={x:this.columnWidth*s,y:r},h=r+t.size.outerHeight,u=this.cols+1-o.length,d=0;u>d;d++)this.colYs[s+d]=h;return a},i.prototype._getColGroup=function(t){if(2>t)return this.colYs;for(var e=[],i=this.cols+1-t,n=0;i>n;n++){var o=this.colYs.slice(n,n+t);e[n]=Math.max.apply(Math,o)}return e},i.prototype._manageStamp=function(t){var i=e(t),n=this._getElementOffset(t),o=this._getOption("originLeft"),r=o?n.left:n.right,s=r+i.outerWidth,a=Math.floor(r/this.columnWidth);a=Math.max(0,a);var h=Math.floor(s/this.columnWidth);h-=s%this.columnWidth?0:1,h=Math.min(this.cols-1,h);for(var u=this._getOption("originTop"),d=(u?n.top:n.bottom)+i.outerHeight,l=a;h>=l;l++)this.colYs[l]=Math.max(d,this.colYs[l])},i.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this._getOption("fitWidth")&&(t.width=this._getContainerFitWidth()),t},i.prototype._getContainerFitWidth=function(){for(var t=0,e=this.cols;--e&&0===this.colYs[e];)t++;return(this.cols-t)*this.columnWidth-this.gutter},i.prototype.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!=this.containerWidth},i});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
/*!
 * Isotope PACKAGED v3.0.1
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * http://isotope.metafizzy.co
 * Copyright 2016 Metafizzy
 */

!function(t,e){"use strict";"function"==typeof define&&define.amd?define("jquery-bridget/jquery-bridget",["jquery"],function(i){e(t,i)}):"object"==typeof module&&module.exports?module.exports=e(t,require("jquery")):t.jQueryBridget=e(t,t.jQuery)}(window,function(t,e){"use strict";function i(i,s,a){function u(t,e,n){var o,s="$()."+i+'("'+e+'")';return t.each(function(t,u){var h=a.data(u,i);if(!h)return void r(i+" not initialized. Cannot call methods, i.e. "+s);var d=h[e];if(!d||"_"==e.charAt(0))return void r(s+" is not a valid method");var l=d.apply(h,n);o=void 0===o?l:o}),void 0!==o?o:t}function h(t,e){t.each(function(t,n){var o=a.data(n,i);o?(o.option(e),o._init()):(o=new s(n,e),a.data(n,i,o))})}a=a||e||t.jQuery,a&&(s.prototype.option||(s.prototype.option=function(t){a.isPlainObject(t)&&(this.options=a.extend(!0,this.options,t))}),a.fn[i]=function(t){if("string"==typeof t){var e=o.call(arguments,1);return u(this,t,e)}return h(this,t),this},n(a))}function n(t){!t||t&&t.bridget||(t.bridget=i)}var o=Array.prototype.slice,s=t.console,r="undefined"==typeof s?function(){}:function(t){s.error(t)};return n(e||t.jQuery),i}),function(t,e){"function"==typeof define&&define.amd?define("ev-emitter/ev-emitter",e):"object"==typeof module&&module.exports?module.exports=e():t.EvEmitter=e()}("undefined"!=typeof window?window:this,function(){function t(){}var e=t.prototype;return e.on=function(t,e){if(t&&e){var i=this._events=this._events||{},n=i[t]=i[t]||[];return-1==n.indexOf(e)&&n.push(e),this}},e.once=function(t,e){if(t&&e){this.on(t,e);var i=this._onceEvents=this._onceEvents||{},n=i[t]=i[t]||{};return n[e]=!0,this}},e.off=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=i.indexOf(e);return-1!=n&&i.splice(n,1),this}},e.emitEvent=function(t,e){var i=this._events&&this._events[t];if(i&&i.length){var n=0,o=i[n];e=e||[];for(var s=this._onceEvents&&this._onceEvents[t];o;){var r=s&&s[o];r&&(this.off(t,o),delete s[o]),o.apply(this,e),n+=r?0:1,o=i[n]}return this}},t}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("get-size/get-size",[],function(){return e()}):"object"==typeof module&&module.exports?module.exports=e():t.getSize=e()}(window,function(){"use strict";function t(t){var e=parseFloat(t),i=-1==t.indexOf("%")&&!isNaN(e);return i&&e}function e(){}function i(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0;h>e;e++){var i=u[e];t[i]=0}return t}function n(t){var e=getComputedStyle(t);return e||a("Style returned "+e+". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1"),e}function o(){if(!d){d=!0;var e=document.createElement("div");e.style.width="200px",e.style.padding="1px 2px 3px 4px",e.style.borderStyle="solid",e.style.borderWidth="1px 2px 3px 4px",e.style.boxSizing="border-box";var i=document.body||document.documentElement;i.appendChild(e);var o=n(e);s.isBoxSizeOuter=r=200==t(o.width),i.removeChild(e)}}function s(e){if(o(),"string"==typeof e&&(e=document.querySelector(e)),e&&"object"==typeof e&&e.nodeType){var s=n(e);if("none"==s.display)return i();var a={};a.width=e.offsetWidth,a.height=e.offsetHeight;for(var d=a.isBorderBox="border-box"==s.boxSizing,l=0;h>l;l++){var f=u[l],c=s[f],m=parseFloat(c);a[f]=isNaN(m)?0:m}var p=a.paddingLeft+a.paddingRight,y=a.paddingTop+a.paddingBottom,g=a.marginLeft+a.marginRight,v=a.marginTop+a.marginBottom,_=a.borderLeftWidth+a.borderRightWidth,I=a.borderTopWidth+a.borderBottomWidth,z=d&&r,x=t(s.width);x!==!1&&(a.width=x+(z?0:p+_));var S=t(s.height);return S!==!1&&(a.height=S+(z?0:y+I)),a.innerWidth=a.width-(p+_),a.innerHeight=a.height-(y+I),a.outerWidth=a.width+g,a.outerHeight=a.height+v,a}}var r,a="undefined"==typeof console?e:function(t){console.error(t)},u=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"],h=u.length,d=!1;return s}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("desandro-matches-selector/matches-selector",e):"object"==typeof module&&module.exports?module.exports=e():t.matchesSelector=e()}(window,function(){"use strict";var t=function(){var t=Element.prototype;if(t.matches)return"matches";if(t.matchesSelector)return"matchesSelector";for(var e=["webkit","moz","ms","o"],i=0;i<e.length;i++){var n=e[i],o=n+"MatchesSelector";if(t[o])return o}}();return function(e,i){return e[t](i)}}),function(t,e){"function"==typeof define&&define.amd?define("fizzy-ui-utils/utils",["desandro-matches-selector/matches-selector"],function(i){return e(t,i)}):"object"==typeof module&&module.exports?module.exports=e(t,require("desandro-matches-selector")):t.fizzyUIUtils=e(t,t.matchesSelector)}(window,function(t,e){var i={};i.extend=function(t,e){for(var i in e)t[i]=e[i];return t},i.modulo=function(t,e){return(t%e+e)%e},i.makeArray=function(t){var e=[];if(Array.isArray(t))e=t;else if(t&&"number"==typeof t.length)for(var i=0;i<t.length;i++)e.push(t[i]);else e.push(t);return e},i.removeFrom=function(t,e){var i=t.indexOf(e);-1!=i&&t.splice(i,1)},i.getParent=function(t,i){for(;t!=document.body;)if(t=t.parentNode,e(t,i))return t},i.getQueryElement=function(t){return"string"==typeof t?document.querySelector(t):t},i.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},i.filterFindElements=function(t,n){t=i.makeArray(t);var o=[];return t.forEach(function(t){if(t instanceof HTMLElement){if(!n)return void o.push(t);e(t,n)&&o.push(t);for(var i=t.querySelectorAll(n),s=0;s<i.length;s++)o.push(i[s])}}),o},i.debounceMethod=function(t,e,i){var n=t.prototype[e],o=e+"Timeout";t.prototype[e]=function(){var t=this[o];t&&clearTimeout(t);var e=arguments,s=this;this[o]=setTimeout(function(){n.apply(s,e),delete s[o]},i||100)}},i.docReady=function(t){var e=document.readyState;"complete"==e||"interactive"==e?t():document.addEventListener("DOMContentLoaded",t)},i.toDashed=function(t){return t.replace(/(.)([A-Z])/g,function(t,e,i){return e+"-"+i}).toLowerCase()};var n=t.console;return i.htmlInit=function(e,o){i.docReady(function(){var s=i.toDashed(o),r="data-"+s,a=document.querySelectorAll("["+r+"]"),u=document.querySelectorAll(".js-"+s),h=i.makeArray(a).concat(i.makeArray(u)),d=r+"-options",l=t.jQuery;h.forEach(function(t){var i,s=t.getAttribute(r)||t.getAttribute(d);try{i=s&&JSON.parse(s)}catch(a){return void(n&&n.error("Error parsing "+r+" on "+t.className+": "+a))}var u=new e(t,i);l&&l.data(t,o,u)})})},i}),function(t,e){"function"==typeof define&&define.amd?define("outlayer/item",["ev-emitter/ev-emitter","get-size/get-size"],e):"object"==typeof module&&module.exports?module.exports=e(require("ev-emitter"),require("get-size")):(t.Outlayer={},t.Outlayer.Item=e(t.EvEmitter,t.getSize))}(window,function(t,e){"use strict";function i(t){for(var e in t)return!1;return e=null,!0}function n(t,e){t&&(this.element=t,this.layout=e,this.position={x:0,y:0},this._create())}function o(t){return t.replace(/([A-Z])/g,function(t){return"-"+t.toLowerCase()})}var s=document.documentElement.style,r="string"==typeof s.transition?"transition":"WebkitTransition",a="string"==typeof s.transform?"transform":"WebkitTransform",u={WebkitTransition:"webkitTransitionEnd",transition:"transitionend"}[r],h={transform:a,transition:r,transitionDuration:r+"Duration",transitionProperty:r+"Property",transitionDelay:r+"Delay"},d=n.prototype=Object.create(t.prototype);d.constructor=n,d._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"})},d.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},d.getSize=function(){this.size=e(this.element)},d.css=function(t){var e=this.element.style;for(var i in t){var n=h[i]||i;e[n]=t[i]}},d.getPosition=function(){var t=getComputedStyle(this.element),e=this.layout._getOption("originLeft"),i=this.layout._getOption("originTop"),n=t[e?"left":"right"],o=t[i?"top":"bottom"],s=this.layout.size,r=-1!=n.indexOf("%")?parseFloat(n)/100*s.width:parseInt(n,10),a=-1!=o.indexOf("%")?parseFloat(o)/100*s.height:parseInt(o,10);r=isNaN(r)?0:r,a=isNaN(a)?0:a,r-=e?s.paddingLeft:s.paddingRight,a-=i?s.paddingTop:s.paddingBottom,this.position.x=r,this.position.y=a},d.layoutPosition=function(){var t=this.layout.size,e={},i=this.layout._getOption("originLeft"),n=this.layout._getOption("originTop"),o=i?"paddingLeft":"paddingRight",s=i?"left":"right",r=i?"right":"left",a=this.position.x+t[o];e[s]=this.getXValue(a),e[r]="";var u=n?"paddingTop":"paddingBottom",h=n?"top":"bottom",d=n?"bottom":"top",l=this.position.y+t[u];e[h]=this.getYValue(l),e[d]="",this.css(e),this.emitEvent("layout",[this])},d.getXValue=function(t){var e=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&!e?t/this.layout.size.width*100+"%":t+"px"},d.getYValue=function(t){var e=this.layout._getOption("horizontal");return this.layout.options.percentPosition&&e?t/this.layout.size.height*100+"%":t+"px"},d._transitionTo=function(t,e){this.getPosition();var i=this.position.x,n=this.position.y,o=parseInt(t,10),s=parseInt(e,10),r=o===this.position.x&&s===this.position.y;if(this.setPosition(t,e),r&&!this.isTransitioning)return void this.layoutPosition();var a=t-i,u=e-n,h={};h.transform=this.getTranslate(a,u),this.transition({to:h,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},d.getTranslate=function(t,e){var i=this.layout._getOption("originLeft"),n=this.layout._getOption("originTop");return t=i?t:-t,e=n?e:-e,"translate3d("+t+"px, "+e+"px, 0)"},d.goTo=function(t,e){this.setPosition(t,e),this.layoutPosition()},d.moveTo=d._transitionTo,d.setPosition=function(t,e){this.position.x=parseInt(t,10),this.position.y=parseInt(e,10)},d._nonTransition=function(t){this.css(t.to),t.isCleaning&&this._removeStyles(t.to);for(var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)},d.transition=function(t){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(t);var e=this._transn;for(var i in t.onTransitionEnd)e.onEnd[i]=t.onTransitionEnd[i];for(i in t.to)e.ingProperties[i]=!0,t.isCleaning&&(e.clean[i]=!0);if(t.from){this.css(t.from);var n=this.element.offsetHeight;n=null}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0};var l="opacity,"+o(a);d.enableTransition=function(){if(!this.isTransitioning){var t=this.layout.options.transitionDuration;t="number"==typeof t?t+"ms":t,this.css({transitionProperty:l,transitionDuration:t,transitionDelay:this.staggerDelay||0}),this.element.addEventListener(u,this,!1)}},d.onwebkitTransitionEnd=function(t){this.ontransitionend(t)},d.onotransitionend=function(t){this.ontransitionend(t)};var f={"-webkit-transform":"transform"};d.ontransitionend=function(t){if(t.target===this.element){var e=this._transn,n=f[t.propertyName]||t.propertyName;if(delete e.ingProperties[n],i(e.ingProperties)&&this.disableTransition(),n in e.clean&&(this.element.style[t.propertyName]="",delete e.clean[n]),n in e.onEnd){var o=e.onEnd[n];o.call(this),delete e.onEnd[n]}this.emitEvent("transitionEnd",[this])}},d.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(u,this,!1),this.isTransitioning=!1},d._removeStyles=function(t){var e={};for(var i in t)e[i]="";this.css(e)};var c={transitionProperty:"",transitionDuration:"",transitionDelay:""};return d.removeTransitionStyles=function(){this.css(c)},d.stagger=function(t){t=isNaN(t)?0:t,this.staggerDelay=t+"ms"},d.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this])},d.remove=function(){return r&&parseFloat(this.layout.options.transitionDuration)?(this.once("transitionEnd",function(){this.removeElem()}),void this.hide()):void this.removeElem()},d.reveal=function(){delete this.isHidden,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("visibleStyle");e[i]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:e})},d.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal")},d.getHideRevealTransitionEndProperty=function(t){var e=this.layout.options[t];if(e.opacity)return"opacity";for(var i in e)return i},d.hide=function(){this.isHidden=!0,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("hiddenStyle");e[i]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:e})},d.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"))},d.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""})},n}),function(t,e){"use strict";"function"==typeof define&&define.amd?define("outlayer/outlayer",["ev-emitter/ev-emitter","get-size/get-size","fizzy-ui-utils/utils","./item"],function(i,n,o,s){return e(t,i,n,o,s)}):"object"==typeof module&&module.exports?module.exports=e(t,require("ev-emitter"),require("get-size"),require("fizzy-ui-utils"),require("./item")):t.Outlayer=e(t,t.EvEmitter,t.getSize,t.fizzyUIUtils,t.Outlayer.Item)}(window,function(t,e,i,n,o){"use strict";function s(t,e){var i=n.getQueryElement(t);if(!i)return void(u&&u.error("Bad element for "+this.constructor.namespace+": "+(i||t)));this.element=i,h&&(this.$element=h(this.element)),this.options=n.extend({},this.constructor.defaults),this.option(e);var o=++l;this.element.outlayerGUID=o,f[o]=this,this._create();var s=this._getOption("initLayout");s&&this.layout()}function r(t){function e(){t.apply(this,arguments)}return e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e}function a(t){if("number"==typeof t)return t;var e=t.match(/(^\d*\.?\d*)(\w*)/),i=e&&e[1],n=e&&e[2];if(!i.length)return 0;i=parseFloat(i);var o=m[n]||1;return i*o}var u=t.console,h=t.jQuery,d=function(){},l=0,f={};s.namespace="outlayer",s.Item=o,s.defaults={containerStyle:{position:"relative"},initLayout:!0,originLeft:!0,originTop:!0,resize:!0,resizeContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}};var c=s.prototype;n.extend(c,e.prototype),c.option=function(t){n.extend(this.options,t)},c._getOption=function(t){var e=this.constructor.compatOptions[t];return e&&void 0!==this.options[e]?this.options[e]:this.options[t]},s.compatOptions={initLayout:"isInitLayout",horizontal:"isHorizontal",layoutInstant:"isLayoutInstant",originLeft:"isOriginLeft",originTop:"isOriginTop",resize:"isResizeBound",resizeContainer:"isResizingContainer"},c._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),n.extend(this.element.style,this.options.containerStyle);var t=this._getOption("resize");t&&this.bindResize()},c.reloadItems=function(){this.items=this._itemize(this.element.children)},c._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,n=[],o=0;o<e.length;o++){var s=e[o],r=new i(s,this);n.push(r)}return n},c._filterFindItemElements=function(t){return n.filterFindElements(t,this.options.itemSelector)},c.getItemElements=function(){return this.items.map(function(t){return t.element})},c.layout=function(){this._resetLayout(),this._manageStamps();var t=this._getOption("layoutInstant"),e=void 0!==t?t:!this._isLayoutInited;this.layoutItems(this.items,e),this._isLayoutInited=!0},c._init=c.layout,c._resetLayout=function(){this.getSize()},c.getSize=function(){this.size=i(this.element)},c._getMeasurement=function(t,e){var n,o=this.options[t];o?("string"==typeof o?n=this.element.querySelector(o):o instanceof HTMLElement&&(n=o),this[t]=n?i(n)[e]:o):this[t]=0},c.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout()},c._getItemsForLayout=function(t){return t.filter(function(t){return!t.isIgnored})},c._layoutItems=function(t,e){if(this._emitCompleteOnItems("layout",t),t&&t.length){var i=[];t.forEach(function(t){var n=this._getItemLayoutPosition(t);n.item=t,n.isInstant=e||t.isLayoutInstant,i.push(n)},this),this._processLayoutQueue(i)}},c._getItemLayoutPosition=function(){return{x:0,y:0}},c._processLayoutQueue=function(t){this.updateStagger(),t.forEach(function(t,e){this._positionItem(t.item,t.x,t.y,t.isInstant,e)},this)},c.updateStagger=function(){var t=this.options.stagger;return null===t||void 0===t?void(this.stagger=0):(this.stagger=a(t),this.stagger)},c._positionItem=function(t,e,i,n,o){n?t.goTo(e,i):(t.stagger(o*this.stagger),t.moveTo(e,i))},c._postLayout=function(){this.resizeContainer()},c.resizeContainer=function(){var t=this._getOption("resizeContainer");if(t){var e=this._getContainerSize();e&&(this._setContainerMeasure(e.width,!0),this._setContainerMeasure(e.height,!1))}},c._getContainerSize=d,c._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?"width":"height"]=t+"px"}},c._emitCompleteOnItems=function(t,e){function i(){o.dispatchEvent(t+"Complete",null,[e])}function n(){r++,r==s&&i()}var o=this,s=e.length;if(!e||!s)return void i();var r=0;e.forEach(function(e){e.once(t,n)})},c.dispatchEvent=function(t,e,i){var n=e?[e].concat(i):i;if(this.emitEvent(t,n),h)if(this.$element=this.$element||h(this.element),e){var o=h.Event(e);o.type=t,this.$element.trigger(o,i)}else this.$element.trigger(t,i)},c.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0)},c.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored},c.stamp=function(t){t=this._find(t),t&&(this.stamps=this.stamps.concat(t),t.forEach(this.ignore,this))},c.unstamp=function(t){t=this._find(t),t&&t.forEach(function(t){n.removeFrom(this.stamps,t),this.unignore(t)},this)},c._find=function(t){return t?("string"==typeof t&&(t=this.element.querySelectorAll(t)),t=n.makeArray(t)):void 0},c._manageStamps=function(){this.stamps&&this.stamps.length&&(this._getBoundingRect(),this.stamps.forEach(this._manageStamp,this))},c._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)}},c._manageStamp=d,c._getElementOffset=function(t){var e=t.getBoundingClientRect(),n=this._boundingRect,o=i(t),s={left:e.left-n.left-o.marginLeft,top:e.top-n.top-o.marginTop,right:n.right-e.right-o.marginRight,bottom:n.bottom-e.bottom-o.marginBottom};return s},c.handleEvent=n.handleEvent,c.bindResize=function(){t.addEventListener("resize",this),this.isResizeBound=!0},c.unbindResize=function(){t.removeEventListener("resize",this),this.isResizeBound=!1},c.onresize=function(){this.resize()},n.debounceMethod(s,"onresize",100),c.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},c.needsResizeLayout=function(){var t=i(this.element),e=this.size&&t;return e&&t.innerWidth!==this.size.innerWidth},c.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},c.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e))},c.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i)}},c.reveal=function(t){if(this._emitCompleteOnItems("reveal",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.reveal()})}},c.hide=function(t){if(this._emitCompleteOnItems("hide",t),t&&t.length){var e=this.updateStagger();t.forEach(function(t,i){t.stagger(i*e),t.hide()})}},c.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e)},c.hideItemElements=function(t){var e=this.getItems(t);this.hide(e)},c.getItem=function(t){for(var e=0;e<this.items.length;e++){var i=this.items[e];if(i.element==t)return i}},c.getItems=function(t){t=n.makeArray(t);var e=[];return t.forEach(function(t){var i=this.getItem(t);i&&e.push(i)},this),e},c.remove=function(t){var e=this.getItems(t);this._emitCompleteOnItems("remove",e),e&&e.length&&e.forEach(function(t){t.remove(),n.removeFrom(this.items,t)},this)},c.destroy=function(){var t=this.element.style;t.height="",t.position="",t.width="",this.items.forEach(function(t){t.destroy()}),this.unbindResize();var e=this.element.outlayerGUID;delete f[e],delete this.element.outlayerGUID,h&&h.removeData(this.element,this.constructor.namespace)},s.data=function(t){t=n.getQueryElement(t);var e=t&&t.outlayerGUID;return e&&f[e]},s.create=function(t,e){var i=r(s);return i.defaults=n.extend({},s.defaults),n.extend(i.defaults,e),i.compatOptions=n.extend({},s.compatOptions),i.namespace=t,i.data=s.data,i.Item=r(o),n.htmlInit(i,t),h&&h.bridget&&h.bridget(t,i),i};var m={ms:1,s:1e3};return s.Item=o,s}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/item",["outlayer/outlayer"],e):"object"==typeof module&&module.exports?module.exports=e(require("outlayer")):(t.Isotope=t.Isotope||{},t.Isotope.Item=e(t.Outlayer))}(window,function(t){"use strict";function e(){t.Item.apply(this,arguments)}var i=e.prototype=Object.create(t.Item.prototype),n=i._create;i._create=function(){this.id=this.layout.itemGUID++,n.call(this),this.sortData={}},i.updateSortData=function(){if(!this.isIgnored){this.sortData.id=this.id,this.sortData["original-order"]=this.id,this.sortData.random=Math.random();var t=this.layout.options.getSortData,e=this.layout._sorters;for(var i in t){var n=e[i];this.sortData[i]=n(this.element,this)}}};var o=i.destroy;return i.destroy=function(){o.apply(this,arguments),this.css({display:""})},e}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-mode",["get-size/get-size","outlayer/outlayer"],e):"object"==typeof module&&module.exports?module.exports=e(require("get-size"),require("outlayer")):(t.Isotope=t.Isotope||{},t.Isotope.LayoutMode=e(t.getSize,t.Outlayer))}(window,function(t,e){"use strict";function i(t){this.isotope=t,t&&(this.options=t.options[this.namespace],this.element=t.element,this.items=t.filteredItems,this.size=t.size)}var n=i.prototype,o=["_resetLayout","_getItemLayoutPosition","_manageStamp","_getContainerSize","_getElementOffset","needsResizeLayout","_getOption"];return o.forEach(function(t){n[t]=function(){return e.prototype[t].apply(this.isotope,arguments)}}),n.needsVerticalResizeLayout=function(){var e=t(this.isotope.element),i=this.isotope.size&&e;return i&&e.innerHeight!=this.isotope.size.innerHeight},n._getMeasurement=function(){this.isotope._getMeasurement.apply(this,arguments)},n.getColumnWidth=function(){this.getSegmentSize("column","Width")},n.getRowHeight=function(){this.getSegmentSize("row","Height")},n.getSegmentSize=function(t,e){var i=t+e,n="outer"+e;if(this._getMeasurement(i,n),!this[i]){var o=this.getFirstItemSize();this[i]=o&&o[n]||this.isotope.size["inner"+e]}},n.getFirstItemSize=function(){var e=this.isotope.filteredItems[0];return e&&e.element&&t(e.element)},n.layout=function(){this.isotope.layout.apply(this.isotope,arguments)},n.getSize=function(){this.isotope.getSize(),this.size=this.isotope.size},i.modes={},i.create=function(t,e){function o(){i.apply(this,arguments)}return o.prototype=Object.create(n),o.prototype.constructor=o,e&&(o.options=e),o.prototype.namespace=t,i.modes[t]=o,o},i}),function(t,e){"function"==typeof define&&define.amd?define("masonry/masonry",["outlayer/outlayer","get-size/get-size"],e):"object"==typeof module&&module.exports?module.exports=e(require("outlayer"),require("get-size")):t.Masonry=e(t.Outlayer,t.getSize)}(window,function(t,e){var i=t.create("masonry");return i.compatOptions.fitWidth="isFitWidth",i.prototype._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns(),this.colYs=[];for(var t=0;t<this.cols;t++)this.colYs.push(0);this.maxY=0},i.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],i=t&&t.element;this.columnWidth=i&&e(i).outerWidth||this.containerWidth}var n=this.columnWidth+=this.gutter,o=this.containerWidth+this.gutter,s=o/n,r=n-o%n,a=r&&1>r?"round":"floor";s=Math[a](s),this.cols=Math.max(s,1)},i.prototype.getContainerWidth=function(){var t=this._getOption("fitWidth"),i=t?this.element.parentNode:this.element,n=e(i);this.containerWidth=n&&n.innerWidth},i.prototype._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth%this.columnWidth,i=e&&1>e?"round":"ceil",n=Math[i](t.size.outerWidth/this.columnWidth);n=Math.min(n,this.cols);for(var o=this._getColGroup(n),s=Math.min.apply(Math,o),r=o.indexOf(s),a={x:this.columnWidth*r,y:s},u=s+t.size.outerHeight,h=this.cols+1-o.length,d=0;h>d;d++)this.colYs[r+d]=u;return a},i.prototype._getColGroup=function(t){if(2>t)return this.colYs;for(var e=[],i=this.cols+1-t,n=0;i>n;n++){var o=this.colYs.slice(n,n+t);e[n]=Math.max.apply(Math,o)}return e},i.prototype._manageStamp=function(t){var i=e(t),n=this._getElementOffset(t),o=this._getOption("originLeft"),s=o?n.left:n.right,r=s+i.outerWidth,a=Math.floor(s/this.columnWidth);a=Math.max(0,a);var u=Math.floor(r/this.columnWidth);u-=r%this.columnWidth?0:1,u=Math.min(this.cols-1,u);for(var h=this._getOption("originTop"),d=(h?n.top:n.bottom)+i.outerHeight,l=a;u>=l;l++)this.colYs[l]=Math.max(d,this.colYs[l])},i.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this._getOption("fitWidth")&&(t.width=this._getContainerFitWidth()),t},i.prototype._getContainerFitWidth=function(){for(var t=0,e=this.cols;--e&&0===this.colYs[e];)t++;return(this.cols-t)*this.columnWidth-this.gutter},i.prototype.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!=this.containerWidth},i}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-modes/masonry",["../layout-mode","masonry/masonry"],e):"object"==typeof module&&module.exports?module.exports=e(require("../layout-mode"),require("masonry-layout")):e(t.Isotope.LayoutMode,t.Masonry)}(window,function(t,e){"use strict";var i=t.create("masonry"),n=i.prototype,o={_getElementOffset:!0,layout:!0,_getMeasurement:!0};for(var s in e.prototype)o[s]||(n[s]=e.prototype[s]);var r=n.measureColumns;n.measureColumns=function(){this.items=this.isotope.filteredItems,r.call(this)};var a=n._getOption;return n._getOption=function(t){return"fitWidth"==t?void 0!==this.options.isFitWidth?this.options.isFitWidth:this.options.fitWidth:a.apply(this.isotope,arguments)},i}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-modes/fit-rows",["../layout-mode"],e):"object"==typeof exports?module.exports=e(require("../layout-mode")):e(t.Isotope.LayoutMode)}(window,function(t){"use strict";var e=t.create("fitRows"),i=e.prototype;return i._resetLayout=function(){this.x=0,this.y=0,this.maxY=0,this._getMeasurement("gutter","outerWidth")},i._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth+this.gutter,i=this.isotope.size.innerWidth+this.gutter;0!==this.x&&e+this.x>i&&(this.x=0,this.y=this.maxY);var n={x:this.x,y:this.y};return this.maxY=Math.max(this.maxY,this.y+t.size.outerHeight),this.x+=e,n},i._getContainerSize=function(){return{height:this.maxY}},e}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-modes/vertical",["../layout-mode"],e):"object"==typeof module&&module.exports?module.exports=e(require("../layout-mode")):e(t.Isotope.LayoutMode)}(window,function(t){"use strict";var e=t.create("vertical",{horizontalAlignment:0}),i=e.prototype;return i._resetLayout=function(){this.y=0},i._getItemLayoutPosition=function(t){t.getSize();var e=(this.isotope.size.innerWidth-t.size.outerWidth)*this.options.horizontalAlignment,i=this.y;return this.y+=t.size.outerHeight,{x:e,y:i}},i._getContainerSize=function(){return{height:this.y}},e}),function(t,e){"function"==typeof define&&define.amd?define(["outlayer/outlayer","get-size/get-size","desandro-matches-selector/matches-selector","fizzy-ui-utils/utils","isotope/js/item","isotope/js/layout-mode","isotope/js/layout-modes/masonry","isotope/js/layout-modes/fit-rows","isotope/js/layout-modes/vertical"],function(i,n,o,s,r,a){return e(t,i,n,o,s,r,a)}):"object"==typeof module&&module.exports?module.exports=e(t,require("outlayer"),require("get-size"),require("desandro-matches-selector"),require("fizzy-ui-utils"),require("isotope/js/item"),require("isotope/js/layout-mode"),require("isotope/js/layout-modes/masonry"),require("isotope/js/layout-modes/fit-rows"),require("isotope/js/layout-modes/vertical")):t.Isotope=e(t,t.Outlayer,t.getSize,t.matchesSelector,t.fizzyUIUtils,t.Isotope.Item,t.Isotope.LayoutMode)}(window,function(t,e,i,n,o,s,r){function a(t,e){return function(i,n){for(var o=0;o<t.length;o++){var s=t[o],r=i.sortData[s],a=n.sortData[s];if(r>a||a>r){var u=void 0!==e[s]?e[s]:e,h=u?1:-1;return(r>a?1:-1)*h}}return 0}}var u=t.jQuery,h=String.prototype.trim?function(t){return t.trim()}:function(t){return t.replace(/^\s+|\s+$/g,"")},d=e.create("isotope",{layoutMode:"masonry",isJQueryFiltering:!0,sortAscending:!0});d.Item=s,d.LayoutMode=r;var l=d.prototype;l._create=function(){this.itemGUID=0,this._sorters={},this._getSorters(),e.prototype._create.call(this),this.modes={},this.filteredItems=this.items,this.sortHistory=["original-order"];for(var t in r.modes)this._initLayoutMode(t)},l.reloadItems=function(){this.itemGUID=0,e.prototype.reloadItems.call(this)},l._itemize=function(){for(var t=e.prototype._itemize.apply(this,arguments),i=0;i<t.length;i++){var n=t[i];n.id=this.itemGUID++}return this._updateItemsSortData(t),t},l._initLayoutMode=function(t){var e=r.modes[t],i=this.options[t]||{};this.options[t]=e.options?o.extend(e.options,i):i,this.modes[t]=new e(this)},l.layout=function(){return!this._isLayoutInited&&this._getOption("initLayout")?void this.arrange():void this._layout()},l._layout=function(){var t=this._getIsInstant();this._resetLayout(),this._manageStamps(),this.layoutItems(this.filteredItems,t),this._isLayoutInited=!0},l.arrange=function(t){this.option(t),this._getIsInstant();var e=this._filter(this.items);this.filteredItems=e.matches,this._bindArrangeComplete(),this._isInstant?this._noTransition(this._hideReveal,[e]):this._hideReveal(e),this._sort(),this._layout()},l._init=l.arrange,l._hideReveal=function(t){this.reveal(t.needReveal),this.hide(t.needHide)},l._getIsInstant=function(){var t=this._getOption("layoutInstant"),e=void 0!==t?t:!this._isLayoutInited;return this._isInstant=e,e},l._bindArrangeComplete=function(){function t(){e&&i&&n&&o.dispatchEvent("arrangeComplete",null,[o.filteredItems])}var e,i,n,o=this;this.once("layoutComplete",function(){e=!0,t()}),this.once("hideComplete",function(){i=!0,t()}),this.once("revealComplete",function(){n=!0,t()})},l._filter=function(t){var e=this.options.filter;e=e||"*";for(var i=[],n=[],o=[],s=this._getFilterTest(e),r=0;r<t.length;r++){var a=t[r];if(!a.isIgnored){var u=s(a);u&&i.push(a),u&&a.isHidden?n.push(a):u||a.isHidden||o.push(a)}}return{matches:i,needReveal:n,needHide:o}},l._getFilterTest=function(t){return u&&this.options.isJQueryFiltering?function(e){return u(e.element).is(t)}:"function"==typeof t?function(e){return t(e.element)}:function(e){return n(e.element,t)}},l.updateSortData=function(t){var e;t?(t=o.makeArray(t),e=this.getItems(t)):e=this.items,this._getSorters(),this._updateItemsSortData(e)},l._getSorters=function(){var t=this.options.getSortData;for(var e in t){var i=t[e];this._sorters[e]=f(i)}},l._updateItemsSortData=function(t){for(var e=t&&t.length,i=0;e&&e>i;i++){var n=t[i];n.updateSortData()}};var f=function(){function t(t){if("string"!=typeof t)return t;var i=h(t).split(" "),n=i[0],o=n.match(/^\[(.+)\]$/),s=o&&o[1],r=e(s,n),a=d.sortDataParsers[i[1]];
return t=a?function(t){return t&&a(r(t))}:function(t){return t&&r(t)}}function e(t,e){return t?function(e){return e.getAttribute(t)}:function(t){var i=t.querySelector(e);return i&&i.textContent}}return t}();d.sortDataParsers={parseInt:function(t){return parseInt(t,10)},parseFloat:function(t){return parseFloat(t)}},l._sort=function(){var t=this.options.sortBy;if(t){var e=[].concat.apply(t,this.sortHistory),i=a(e,this.options.sortAscending);this.filteredItems.sort(i),t!=this.sortHistory[0]&&this.sortHistory.unshift(t)}},l._mode=function(){var t=this.options.layoutMode,e=this.modes[t];if(!e)throw new Error("No layout mode: "+t);return e.options=this.options[t],e},l._resetLayout=function(){e.prototype._resetLayout.call(this),this._mode()._resetLayout()},l._getItemLayoutPosition=function(t){return this._mode()._getItemLayoutPosition(t)},l._manageStamp=function(t){this._mode()._manageStamp(t)},l._getContainerSize=function(){return this._mode()._getContainerSize()},l.needsResizeLayout=function(){return this._mode().needsResizeLayout()},l.appended=function(t){var e=this.addItems(t);if(e.length){var i=this._filterRevealAdded(e);this.filteredItems=this.filteredItems.concat(i)}},l.prepended=function(t){var e=this._itemize(t);if(e.length){this._resetLayout(),this._manageStamps();var i=this._filterRevealAdded(e);this.layoutItems(this.filteredItems),this.filteredItems=i.concat(this.filteredItems),this.items=e.concat(this.items)}},l._filterRevealAdded=function(t){var e=this._filter(t);return this.hide(e.needHide),this.reveal(e.matches),this.layoutItems(e.matches,!0),e.matches},l.insert=function(t){var e=this.addItems(t);if(e.length){var i,n,o=e.length;for(i=0;o>i;i++)n=e[i],this.element.appendChild(n.element);var s=this._filter(e).matches;for(i=0;o>i;i++)e[i].isLayoutInstant=!0;for(this.arrange(),i=0;o>i;i++)delete e[i].isLayoutInstant;this.reveal(s)}};var c=l.remove;return l.remove=function(t){t=o.makeArray(t);var e=this.getItems(t);c.call(this,t);for(var i=e&&e.length,n=0;i&&i>n;n++){var s=e[n];o.removeFrom(this.filteredItems,s)}},l.shuffle=function(){for(var t=0;t<this.items.length;t++){var e=this.items[t];e.sortData.random=Math.random()}this.options.sortBy="random",this._sort(),this._layout()},l._noTransition=function(t,e){var i=this.options.transitionDuration;this.options.transitionDuration=0;var n=t.apply(this,e);return this.options.transitionDuration=i,n},l.getFilteredItemElements=function(){return this.filteredItems.map(function(t){return t.element})},d});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
;
(function () {
    "use strict"

    var $window = $(window),
        $document = $(document);

    var defaultTheme = {
        isElementInViewport: function (el) {
            if (typeof jQuery === "function" && el instanceof jQuery) {
                el = el[0];
            }
            var rect = el.getBoundingClientRect();
            return (
                rect.top >= 0 &&
                rect.top <= (window.innerHeight || document.documentElement.clientHeight)
            );
        },
    }

    window.defaultTheme = defaultTheme;


    $document.ready(function () {
        $(document).ready(function () {
            if ($('.main-content > div:first').find('section').hasClass('js-header-transparent')) {

            } else {
                $('.navigation-holder').addClass('not-transparent');
            }
        })

        if ($(document.body).hasClass('sticky-nav')) {
            var navHeight = $('.navigation').outerHeight();
            defaultTheme.stickyNav();
        }
    });


    /* ###################### Counter ###################### */
    var numbCount = function (el) {
        var html = el.innerHTML.trim();
        var to = parseInt(html, 10);
        var inc = 120;
        if (to > 20) inc = 60;
        if (to > 60) inc = 40;
        if (to > 120) inc = 10;
        if (to > 320) inc = 5;
        if (to > 1220) inc = 3;
        if (to > 5000) inc = 1;
        if (!isNaN(to)) {
            var time = 10;
            for (var i = 1; i <= to; i++) {
                time += inc;
                (function (time, i, el) {
                    setTimeout(function () {
                        el.innerHTML = i;
                    }, time)
                })(time, i, el)
            }
        }
    }

    $.fn.isOnScreen = function () {
        var win = $window;

        var viewport = {
            top: win.scrollTop(),
            left: win.scrollLeft()
        };
        viewport.right = viewport.left + win.width();
        viewport.bottom = viewport.top + win.height();

        var bounds = this.offset();
        bounds.right = bounds.left + this.outerWidth();
        bounds.bottom = bounds.top + this.outerHeight();

        return (!(viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom));
    };


    $window.on('load resize scroll', function () {
        setTimeout(function () {
            $('[data-counter]').each(function () {
                if ($(this).isOnScreen()) {
                    $(this).css({'visibility': 'visible'});
                    $(this).removeClass('js-start-from-zero');
                    if (!this.__activated) {

                        this.__activated = true;
                        numbCount(this);
                    }
                }
            });
        }, 10);

        $(".menu").css('maxHeight', ($window.height() - $(".navigation").outerHeight()))
    });


    /* ###################### Tabs ###################### */
    $document.ready(function () {
        var numTabs = $('.tabs .nav-tabs:not(.as-buttons)').find('li').length;
        var tabWidth = 100 / numTabs;
        var tabPercent = tabWidth + "%";
        $('.nav-tabs li').width(tabPercent);
    });
    /* ###################### Tabs ###################### */

    /* ###################### Section 4 and 5 padding ###################### */

    /* ###################### Top Top ###################### */
    $document.ready(function () {
        var ttopButton = $("#to-top");
        ttopButton.hide().on("click", function () {
            $("html, body").animate({
                scrollTop: 0
            }, "slow");
        });
        $window.scroll(function () {
            if ($window.scrollTop() === 0) {
                ttopButton.hide();
            } else {
                ttopButton.show();
            }
        });
    });
    /* ###################### To Top ###################### */

    /* ###################### Google Maps ###################### */
    $document.ready(function () {
        if ($('#map').length > 0) {
            var latitude = 42.662104;
            var longtitude = 23.3163666;
            var isDraggable = $document.width() > 991 ? true : false; // If document (your website) is wider than 480px, isDraggable = true, else isDraggable = false

            var locations = [
                ['', latitude, longtitude, 2]
            ];
            var styles = [
                {
                    "featureType": "all",
                    "elementType": "labels.text.fill",
                    "stylers": [
                        {
                            "saturation": 36
                        },
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 40
                        }
                    ]
                },
                {
                    "featureType": "all",
                    "elementType": "labels.text.stroke",
                    "stylers": [
                        {
                            "visibility": "on"
                        },
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 16
                        }
                    ]
                },
                {
                    "featureType": "all",
                    "elementType": "labels.icon",
                    "stylers": [
                        {
                            "visibility": "off"
                        }
                    ]
                },
                {
                    "featureType": "administrative",
                    "elementType": "geometry.fill",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 20
                        }
                    ]
                },
                {
                    "featureType": "administrative",
                    "elementType": "geometry.stroke",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 17
                        },
                        {
                            "weight": 1.2
                        }
                    ]
                },
                {
                    "featureType": "landscape",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 20
                        }
                    ]
                },
                {
                    "featureType": "poi",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 21
                        }
                    ]
                },
                {
                    "featureType": "road.highway",
                    "elementType": "geometry.fill",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 17
                        }
                    ]
                },
                {
                    "featureType": "road.highway",
                    "elementType": "geometry.stroke",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 29
                        },
                        {
                            "weight": 0.2
                        }
                    ]
                },
                {
                    "featureType": "road.arterial",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 18
                        }
                    ]
                },
                {
                    "featureType": "road.local",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 16
                        }
                    ]
                },
                {
                    "featureType": "transit",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 19
                        }
                    ]
                },
                {
                    "featureType": "water",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#000000"
                        },
                        {
                            "lightness": 17
                        }
                    ]
                }
            ];

            var map = new google.maps.Map(document.getElementById('map'), {
                zoom: 17,
                scrollwheel: false,
                navigationControl: true,
                mapTypeControl: false,
                scaleControl: false,
                draggable: isDraggable,
                styles: styles,
                center: new google.maps.LatLng(latitude, longtitude),
                mapTypeId: google.maps.MapTypeId.ROADMAP
            });
            var infowindow = new google.maps.InfoWindow();
            var marker, i;
            for (i = 0; i < locations.length; i++) {
                marker = new google.maps.Marker({
                    position: new google.maps.LatLng(locations[i][1], locations[i][2]),
                    map: map,
                    icon: 'assets/img/section-16/marker.png'
                });
                google.maps.event.addListener(marker, 'click', (function (marker, i) {
                    return function () {
                        infowindow.setContent(locations[i][0]);
                    }
                })(marker, i));
            }
        }
    });
    /* ###################### Google Maps ###################### */


    /* ###################### Tooltip ###################### */
    $document.ready(function () {
        $('[data-toggle="tooltip"]').tooltip()
    });
    /* ###################### Tooltip ###################### */

    /* ###################### Project Gallery ###################### */
    function loadPortfolioGallerySettings() {

        return false;

        if ($window.width() > 991) {
            var projectGalleryHeight = $('.portfolio-inner-page .project-gallery').height();
            var projectGalleryWidth = $('.portfolio-inner-page .project-gallery').width();
            var projectInfoHeight = $('.portfolio-inner-page .project-info').height();
            $('.portfolio-inner-page .project-info').css({'max-width': projectGalleryWidth + 'px'});
            $('.portfolio-inner-page .js-in-viewport').css({'margin-top': projectInfoHeight + 'px'});
        } else {
            if ($('.portfolio-inner-page .project-gallery').length > 0) {
                $('.portfolio-inner-page .project-gallery').each(function () {
                    var el = $(this);
                    el.slick({
                        centerMode: true,
                        centerPadding: '0px',
                        slidesToShow: 1,
                        arrows: true,
                        dots: false,
                        adaptiveHeight: true
                    });
                });
            }
        }
    }

    $document.ready(function () {
        loadPortfolioGallerySettings();
    });

    $document.on('resize', function () {
        loadPortfolioGallerySettings();
    });


    $window.on('load', function () {
        /* ###################### Project Gallery ###################### */

        var pInfo = $('.project-info');

        pInfo.stickySidebar({
            containerSelector: '.project-holder',
            innerWrapperSelector: '.project-info-content',
            topSpacing: 115,
            bottomSpacing: 115
        });
    })

    $document.ready(function () {
        /* ###################### Magnific Popup with Video ###################### */
        $('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
            disableOn: 700,
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,

            fixedContentPos: false
        });
    });
    /* ###################### Magnific Popup with Video ###################### */

    /* ###################### Zoom Container Open Image ###################### */
    // $document.ready(function () {
    //     $('.zoomWindow').on('click', function () {
    //         var img = $(this).css('background-image');
    //         console.log(img);
    //     });
    // });
    /* ###################### Zoom Container Open Image ###################### */

    /* ###################### Video Section ###################### */
    function setHeightOnVideos() {
        var headerheight = $('.navigation-holder').height();
        var windowheight = $(window).height();
        $('.video-section').css('height', windowheight - headerheight + "px");
        $('.video-section .video').css('height', windowheight - headerheight + "px");
        $('.video-section .container-fluid').css('height', windowheight - headerheight + "px");
        $('#main').css('margin-top', headerheight + "px");
    }

    $document.ready(function () {
        setHeightOnVideos();
    });

    $window.on('resize', function () {
        setHeightOnVideos();
    });
    /* ###################### Video Section ###################### */

    /* ###################### Quantity ###################### */

    $document.ready(function () {
        $(".arrow.minus").on("click", function (m) {
            var i = $(this).parent().parent().find('input[name="quantity"], input[name="qty"], .js-qty');
            if (i.val() <= 1) {
                i.val("1").change();
            } else {
                var l = i.val() - 1;
                i.val(l).change();
            }
        });
        $(".arrow.plus").on("click", function (m) {
            var i = $(this).parent().parent().find('input[name="quantity"], input[name="qty"], .js-qty');
            if (i.val() <= 19) {
                var l = +i.val() + +1;
                i.val(l).change();
            }
        });
    });
    /* ###################### Quantity ###################### */
})();

$(document).ready(function () {
    $('#mw-template-new-world').removeClass('module');
})

/*$(document).ready(function () {
 $('.navigation .menu .list.menu-root').collapseNav({
 responsive: 1,
 mobile_break: 992,
 li_class: 'has-sub-menu dropdown'
 });

 if ($(window).width() <= 991) {
 $('.navigation .menu .list.menu-root .has-sub-menu a.dropdown-toggle').attr('href', 'javascript:;');
 $('.navigation .menu .list.menu-root .has-sub-menu').on('click', function (e) {
 // e.preventDefault();
 })
 }
 })*/

/* Ajax Loading */
$(window).on('load', function () {
    setTimeout(function () {
        $('body').addClass('page-loaded');
    }, 900);
})


$(document).ready(function () {
    $('.js-show-posts').on('click', function () {
        if ($(window).width() >= 992) {
            if ($('.js-posts-menu').hasClass('opened')) {
                $('.js-posts-menu').slideUp('slow');
                $('.js-posts-menu').removeClass('opened');
            } else {
                $('.js-posts-menu').slideDown('slow');
                $('.js-posts-menu').addClass('opened');
            }
        } else {
            if ($('.js-posts-menu').hasClass('opened')) {
                $('.js-posts-menu').hide("slide", {direction: "right"}, 500);
                $('.js-posts-menu').removeClass('opened');
            } else {
                $('.js-posts-menu').show("slide", {direction: "right"}, 500);
                $('.js-posts-menu').addClass('opened');
            }
        }
    });
})


function percent(num_amount, num_total) {
    if (num_amount == 0 || num_total == 0) {
        return 0;
    }
    var count1 = num_amount / num_total;
    var count2 = count1 * 100;

    count = count2;

    return count;
}


function setPaddingToSections() {
    if ($(window).width() > 991) {
        var headerWidth = $('.navigation-holder').width();
        var headerContainerWidth = $('.navigation-holder .navigation .container').width();
        var headerContainerFluidWidth = $('.container-fluid').width();

        var oneFluidColumn = headerContainerFluidWidth / 12;
        if ($(window).width() > 1199) {
            // oneFluidColumn = headerContainerFluidWidth / 12;
        }

        var oneColumn = 0;
        if ($(window).width() > 1199) {
            oneColumn = headerContainerWidth / 12;
        }

        $('.home-slider .container.info-holder').css({'padding-left': oneColumn + 'px', 'padding-right': oneColumn + 'px'});
        $('.home-slider .bx-controls-direction').css({'width': headerContainerWidth + 'px'});
    } else {

        $('.home-slider .container.info-holder').css({'padding-left': '40px', 'padding-right': '40px'});
        $('.home-slider .bx-controls-direction').css({'width': headerContainerWidth + 'px'});
    }

    if ($('html').attr('dir') == 'rtl') {
        if ($(window).width() > 991) {
            $('.section-16').each(function () {
                var leftSide = $(this).find('.left-side');
                leftSide.css({'padding-right': ((headerWidth - headerContainerWidth ) / 2) + 10 + oneColumn + 'px'});
                leftSide.find('.info-holder').css({'margin-left': '-' + oneFluidColumn + 'px'});
            })

            $('.section-17').each(function () {
                var rightSide = $(this).find('.right-side');
                rightSide.css({'padding-left': ((headerWidth - headerContainerWidth ) / 2) + 10 + oneColumn + 'px'});
                rightSide.find('.info-holder').css({'margin-right': '-' + oneFluidColumn + 'px'});
            })
        } else {
            $('.section-16').each(function () {
                var leftSide = $(this).find('.left-side');
                leftSide.css({'padding-right': ''});
                leftSide.find('.info-holder').css({'margin-left': ''});
            })

            $('.section-17').each(function () {
                var rightSide = $(this).find('.right-side');
                rightSide.css({'padding-left': ''});
                rightSide.find('.info-holder').css({'margin-right': ''});
            })
        }
    } else {
        if ($(window).width() > 991) {
            $('.section-16').each(function () {
                var leftSide = $(this).find('.left-side');
                leftSide.css({'padding-left': ((headerWidth - headerContainerWidth ) / 2) + 10 + oneColumn + 'px'});
                leftSide.find('.info-holder').css({'margin-right': '-' + oneFluidColumn + 'px'});
            })

            $('.section-17').each(function () {
                var rightSide = $(this).find('.right-side');
                rightSide.css({'padding-right': ((headerWidth - headerContainerWidth ) / 2) + 10 + oneColumn + 'px'});
                rightSide.find('.info-holder').css({'margin-left': '-' + oneFluidColumn + 'px'});
            })
        } else {
            $('.section-16').each(function () {
                var leftSide = $(this).find('.left-side');
                leftSide.css({'padding-left': ''});
                leftSide.find('.info-holder').css({'margin-right': ''});
            })
            $('.section-17').each(function () {
                var rightSide = $(this).find('.right-side');
                rightSide.css({'padding-right': ''});
                rightSide.find('.info-holder').css({'margin-left': ''});
            });
        }
    }
}

$(document).ready(function () {
    setPaddingToSections();
});

$(window).on('resize', function () {
    setPaddingToSections();
});


/* ###################### Masonry Gallery with Magnific Popup ###################### */
function istotopeFilter() {
    var filterValue = '.masonry-holder';

    $('.masonry-team .js-masonry-grid-works-filter .list-masonry-grid-works-filter__item a.list-masonry-grid-works-filter__link_active').each(function (index) {
        filterValue = filterValue + ', ' + $(this).attr('data-filter');
    });

    if (filterValue == '.masonry-holder') {
        $('.js-masonry-grid-works-filter li:first-of-type a').addClass('btn-primary list-masonry-grid-works-filter__link_active');
        $('.js-masonry-grid-works-filter li:first-of-type a').removeClass('btn-outline-primary shadow-md');
        filterValue = '*';
    }

    masonryGrid.isotope({
        filter: filterValue
    });

    // console.log(filterValue);
}


var masonryGrid = $('.masonry-team .js-masonry-grid-works');


$(window).on('load', function () {
    // masonry grid
    setTimeout(function () {
        masonryGrid.masonry({
            itemSelector: '.js-masonry-grid-works__item',
            columnWidth: '.js-masonry-grid-works__sizer',
            percentPosition: true
        }).isotope();
    }, 10);
});


$(document).ready(function () {
    // isotope filtering panel
    $('.masonry-team .js-masonry-grid-works-filter').on('click', 'a:not(.all)', function (e) {
        e.preventDefault();

        $('body').find('a.all').removeClass('btn-primary list-masonry-grid-works-filter__link_active');
        $('body').find('a.all').addClass('btn-outline-primary shadow-md');

        $(this).addClass('btn-primary list-masonry-grid-works-filter__link_active');
        $(this).removeClass('btn-outline-primary shadow-md');

        istotopeFilter();
    });

    $('.masonry-team .js-masonry-grid-works-filter').on('click', 'a.list-masonry-grid-works-filter__link_active', function (e) {
        e.preventDefault();

        $(this).removeClass('btn-primary list-masonry-grid-works-filter__link_active');
        $(this).addClass('btn-outline-primary shadow-md');

        istotopeFilter();
    });


    $('.masonry-team .js-masonry-grid-works-filter').on('click', 'a.all', function (e) {
        e.preventDefault();

        $('.masonry-team .js-masonry-grid-works-filter .list-masonry-grid-works-filter__item a.list-masonry-grid-works-filter__link_active').each(function (index) {
            $(this).removeClass('btn-primary list-masonry-grid-works-filter__link_active');
            $(this).addClass('btn-outline-primary shadow-md');
        });

        $(this).removeClass('btn-outline-primary shadow-md');
        $(this).addClass('btn-primary list-masonry-grid-works-filter__link_active');

        istotopeFilter();
    });
});
/* ###################### Masonry Gallery with Magnific Popup ###################### */


$(document).ready(function () {
    if (!$('body').hasClass('mw-live-edit')) {
         AOS.init();
    }
})


/* ###################### Elevate Zoom ###################### */
$(document).ready(function () {

    var elevateZoomTurnOn = $(document).width() > 991 ? true : false;

    if (elevateZoomTurnOn) {
        $("#elevatezoom").elevateZoom({
            gallery: 'elevatezoom-gallery',
            cursor: "crosshair",
            galleryActiveClass: 'active',
            imageCrossfade: true,
            zoomType: "inner"
        });


        //pass the images to Fancybox
        $("#elevatezoom").bind("click", function (e) {
            var ez = $('#elevatezoom').data('elevateZoom');

            var res = [];
            $.each(ez.getGalleryList(), function () {
                res.push({src: this.href})
            });

            $.magnificPopup.open({
                items: res,
                gallery: {
                    enabled: true
                },
                type: 'image'
            });

            return false;
        });
    }

    var eGallery = $('#elevatezoom-gallery');
    if (eGallery.length > 0) {
        eGallery.each(function () {
            var el = $(this);
            el.slick({
                centerMode: true,
                centerPadding: '0',
                slidesToShow: 5,
                slidesToScroll: 1,
                arrows: true,
                autoplay: false,
                autoplaySpeed: 2000,
                dots: false,
                infinite: true,
                responsive: [
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 2
                        }
                    }
                ]
            });
        });
    }
});
/* ###################### Elevate Zoom ###################### */



/* ###################### Navigation ###################### */

// Sidebar navigation menu
function sidbarNav() {
    if ($('.navigation').hasClass('js-sidebar-nav')) {

        $('html').addClass('sidebar-nav-website');
        var sidebarNavElemOfset = $('html.sidebar-nav-website body.sticky-nav .navigation .menu-overlay');
        var navHeight = $('.navigation').outerHeight();

        if ($(window).width() > 768) {
            $(sidebarNavElemOfset).css({'margin-top': navHeight + 'px'});
        } else {
            $(sidebarNavElemOfset).css({'margin-top': ''});
        }

        if ($(window).width() > 1366) {
            $('.sidebar-nav-website .toggle a').addClass('blocked-toggle');
            $('.sidebar-nav-website .toggle a').on('click', function () {
                $('.sidebar-nav-website .slick-slider').slick('refresh').slick('setPosition');
            });

        } else {
            $('.sidebar-nav-website .toggle a').removeClass('blocked-toggle');

            $(document.body).on('click', function (ev) {
                var curr = $(ev.target);
                if (curr.parents('.menu-overlay,.toggle').length === 0) {
                    $('html.sidebar-nav-website').removeClass('mobile-menu-active');
                    $('html.sidebar-nav-website .toggle a').removeClass('active');
                    $('html.sidebar-nav-website .navigation .menu').removeClass('main-menu-open');
                }
            });
        }

    }
}

/*
 if (!Cookies.get('sidebar-nav-state')) {
 Cookies.set('sidebar-nav-state', 'open');
 }
 */

function sidbarNavEvent() {
    if (window.matchMedia("(min-width: 1366px)").matches) {
        if ($('html').hasClass('sidebar-nav-website')) {
            //$('html').addClass('mobile-menu-active');
            $('.sidebar-nav-website .js-menu-toggle').on('click', function () {
                if ($('html').hasClass('mobile-menu-active')) {
                    Cookies.set('sidebar-nav-state', 'open');
                } else {
                    Cookies.set('sidebar-nav-state', 'close');
                }
            });

            if (Cookies.get('sidebar-nav-state') == 'open') {
                $('html').addClass('mobile-menu-active');
            } else {
                $('html').removeClass('mobile-menu-active');
            }
        }
    } else {
        if ($('html').hasClass('sidebar-nav-website')) {
            $('html').removeClass('mobile-menu-active');
        }
        if ($('.sidebar-nav-website .toggle a').hasClass('active')) {
            $('.sidebar-nav-website .toggle a').removeClass('active');
        }

    }
}


// Shopping cart
$(document).on('click', '.dropdown-menu.shopping-cart', function (event) {
    if ($(event.target.nodeName !== 'A')) {
        event.stopPropagation();
    }
});


//General for all header menu
if ($('.dropdown-menu li').hasClass('active')) {
    var $this = $('.dropdown-menu li.active');
    $($this).closest('.dropdown').addClass('active');
}

$(".navigation .menu li, .navigation .secondary-menu li").each(function () {
    if ($(this.children).filter('ul').length > 0) {
        $(this).addClass('has-sub-menu');
    }
});

// Main menu

$(document.body).on('click', function (e) {
    var curr = $(e.target);
    if (curr.parents('.menu-overlay,.toggle').length === 0) {
        $('html:not(.sidebar-nav-website)').removeClass('mobile-menu-active');
        $('html:not(.sidebar-nav-website) .js-menu-toggle').removeClass('active');
        $('html:not(.sidebar-nav-website) body').removeClass('lock-scroll');
        $('html:not(.sidebar-nav-website) .navigation .menu').removeClass('main-menu-open');
    }
});

$('.js-menu-toggle').on('click', function () {
    if ($('html').hasClass('mobile-menu-active')) {
        $('html').removeClass('mobile-menu-active');
        $('html:not(.sidebar-nav-website) body').removeClass('lock-scroll');

    } else {
        $('html').addClass('mobile-menu-active');
        $('html:not(.sidebar-nav-website) body').addClass('lock-scroll');
    }

    if ($('.js-menu-toggle').hasClass('active')) {
        $('.js-menu-toggle').removeClass('active');
    } else {
        $('.js-menu-toggle').addClass('active');
    }

    $('.navigation .secondary-menu').removeClass('secondary-menu-open');
    $('.js-extra-menu-toggle').removeClass('active');
    $('body').removeClass('lock-scroll-extra-menu');
});

$(document).on("click", ".menu .module-menu .has-sub-menu > a", function (e) {
    var parent = $(this).parent();
    var ul = parent.children('ul');
    //console.log($('.mobile-menu-active').length > 0);
    if (ul.length === 1 && $('.mobile-menu-active').length > 0) {
        e.preventDefault();
        this.classList.toggle('submenu-expanded');
        var content = this.nextElementSibling;
        content.classList.toggle('active-icon');
        ul.slideToggle(function () {
            if (this.style.display == 'none') {
                this.style.display = '';
            }
        });
    }
});

// Only for Main menu mobile member nav
$(".menu .mobile-profile.has-sub-menu > a").on("click", function (e) {
    var parent = $(this).parent();
    var ul = parent.children('ul');
    console.log($('.mobile-menu-active').length > 0);
    if (ul.length === 1 && $('.mobile-menu-active').length > 0) {
        e.preventDefault();
        ul.slideToggle(function () {
            if (this.style.display == 'none') {
                this.style.display = '';
            }
        });
    }
});


// Sidebar navigation menu
sidbarNav();
sidbarNavEvent();
$(window).on('resize', function () {
    sidbarNav();
});


// Second menu
$(document.body).on('click', function (e) {
    var curr = $(e.target);
    if (curr.parents('.secondary-menu,.extra-toggle').length === 0) {
        $('html').removeClass('mobile-extra-menu-active');
        $('.navigation .secondary-menu').removeClass('secondary-menu-open');
        $('.js-extra-menu-toggle').removeClass('active');
        $('body').removeClass('lock-scroll-extra-menu');
    }
});

$('.js-extra-menu-toggle').on('click', function () {
    $('html').toggleClass('mobile-extra-menu-active');
    $('body').toggleClass('lock-scroll-extra-menu');

    if ($('html').hasClass('mobile-extra-menu-active')) {
        $('.js-extra-menu-toggle').addClass('active');
        $('.navigation .secondary-menu').addClass('secondary-menu-open');
        $('.navigation .menu').removeClass('main-menu-open');
    } else {
        $('.navigation .secondary-menu').removeClass('secondary-menu-open');
        $('.js-extra-menu-toggle').removeClass('active');
    }
    $('.js-menu-toggle').removeClass('active');
    $('.dropdown').removeClass('show');
    $('.dropdown-menu').removeClass('show');
    $('body').removeClass('lock-scroll');
});

$(document).on("click", ".secondary-menu .module-menu .has-sub-menu > a", function (e) {
    var parent = $(this).parent();
    var ul = parent.children('ul');
    //console.log($('.mobile-extra-menu-active').length > 0);
    if (ul.length === 1 && $('.mobile-extra-menu-active').length > 0) {
        e.preventDefault();
        ul.slideToggle(function () {
            if (this.style.display == 'none') {
                this.style.display = '';
            }
        });
    }
});
// Only for Secondary menu mobile member nav
$(".secondary-menu .mobile-profile.has-sub-menu > a").on("click", function (e) {
    var parent = $(this).parent();
    var ul = parent.children('ul');
    console.log($('.mobile-extra-menu-active').length > 0);
    if (ul.length === 1 && $('.mobile-extra-menu-active').length > 0) {
        e.preventDefault();
        ul.slideToggle(function () {
            if (this.style.display == 'none') {
                this.style.display = '';
            }
        });
    }
});

$(document).ready(function () {
    $('.navigation .menu .list.menu-root').collapseNav({
        responsive: 1,
        mobile_break: 992,
        li_class: 'has-sub-menu dropdown'
    });

    if ($(window).width() <= 991) {
        $('.navigation .menu .list.menu-root .has-sub-menu a.dropdown-toggle').attr('href', 'javascript:;');
        $('.navigation .menu .list.menu-root .has-sub-menu').on('click', function (e) {
            // e.preventDefault();
        })
    }
});

$(".dropdown.has-sub-menu").on("click", function (e) {
    $(this).toggleClass('show');
});

/*
$(document).on('click', '.dropdown.has-sub-menu > a', function (event) {
    event.preventDefault();
});
*/

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
